/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.EmptyDataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelUtils;
import org.apache.metamodel.excel.SpreadsheetReaderDelegate;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingContextImpl;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSpreadsheetReaderDelegate
implements SpreadsheetReaderDelegate {
    static final ColumnType DEFAULT_COLUMN_TYPE = ColumnType.STRING;
    static final ColumnType LEGACY_COLUMN_TYPE = ColumnType.VARCHAR;
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpreadsheetReaderDelegate.class);
    private final Resource _resource;
    private final ExcelConfiguration _configuration;

    public DefaultSpreadsheetReaderDelegate(Resource resource, ExcelConfiguration configuration) {
        this._resource = resource;
        this._configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema createSchema(String schemaName) {
        MutableSchema mutableSchema;
        MutableSchema schema = new MutableSchema(schemaName);
        Workbook wb = ExcelUtils.readWorkbook(this._resource, true);
        try {
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                Sheet currentSheet = wb.getSheetAt(i);
                MutableTable table = this.createTable(wb, currentSheet);
                table.setSchema((Schema)schema);
                schema.addTable((Table)table);
            }
            mutableSchema = schema;
        }
        catch (Throwable throwable) {
            FileHelper.safeClose((Object[])new Object[]{wb});
            throw throwable;
        }
        FileHelper.safeClose((Object[])new Object[]{wb});
        return mutableSchema;
    }

    @Override
    public DataSet executeQuery(Table table, List<Column> columns, int maxRows) {
        Workbook wb = ExcelUtils.readWorkbook(this._resource, true);
        Sheet sheet = wb.getSheet(table.getName());
        if (sheet == null || sheet.getPhysicalNumberOfRows() == 0) {
            return new EmptyDataSet(columns.stream().map(SelectItem::new).collect(Collectors.toList()));
        }
        DataSet dataSet = ExcelUtils.getDataSet(wb, sheet, table, this._configuration);
        if (maxRows > 0) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    @Override
    public void notifyTablesModified() {
    }

    private MutableTable createTable(Workbook wb, Sheet sheet) {
        ColumnType[] columnTypes;
        MutableTable table = new MutableTable(sheet.getSheetName(), TableType.TABLE);
        if (sheet.getPhysicalNumberOfRows() <= 0) {
            return table;
        }
        Iterator<Row> rowIterator = ExcelUtils.getRowIterator(sheet, this._configuration, false);
        if (!rowIterator.hasNext()) {
            return table;
        }
        Row row = null;
        if (this._configuration.isSkipEmptyLines()) {
            while (row == null && rowIterator.hasNext()) {
                row = rowIterator.next();
            }
        } else {
            row = rowIterator.next();
        }
        if ((columnTypes = this.getColumnTypes(sheet)) == null) {
            return table;
        }
        int columnNameLineNumber = this._configuration.getColumnNameLineNumber();
        if (columnNameLineNumber == 0) {
            while (row == null && rowIterator.hasNext()) {
                row = rowIterator.next();
            }
            ColumnNamingStrategy columnNamingStrategy = this._configuration.getColumnNamingStrategy();
            try (ColumnNamingSession columnNamingSession = columnNamingStrategy.startColumnNamingSession();){
                int i;
                int offset = this.getColumnOffset(row);
                for (i = 0; i < offset; ++i) {
                    columnNamingSession.getNextColumnName((ColumnNamingContext)new ColumnNamingContextImpl(i));
                }
                for (i = offset; i < row.getLastCellNum(); ++i) {
                    ColumnNamingContextImpl namingContext = new ColumnNamingContextImpl((Table)table, null, i);
                    MutableColumn column = new MutableColumn(columnNamingSession.getNextColumnName((ColumnNamingContext)namingContext), columnTypes[i], (Table)table, i, Boolean.valueOf(true));
                    table.addColumn((Column)column);
                }
            }
        } else if ((row = this.iterateToColumnNameRow(rowIterator, row)) != null) {
            this.createColumns(table, wb, row, columnTypes);
        }
        return table;
    }

    private Row iterateToColumnNameRow(Iterator<Row> rowIterator, Row currentRow) {
        Row row = currentRow;
        for (int i = 1; i < this._configuration.getColumnNameLineNumber(); ++i) {
            if (!rowIterator.hasNext()) {
                return null;
            }
            row = rowIterator.next();
        }
        return row;
    }

    private ColumnType[] getColumnTypes(Sheet sheet) {
        Iterator<Row> iterator = ExcelUtils.getRowIterator(sheet, this._configuration, false);
        Row row = this._configuration.getColumnNameLineNumber() == 0 ? DefaultSpreadsheetReaderDelegate.findTheFirstNonEmptyRow(iterator) : this.iterateToColumnNameRow(iterator, iterator.next());
        if (row == null) {
            return null;
        }
        Object[] columnTypes = new ColumnType[row.getLastCellNum()];
        if (this._configuration.isDetectColumnTypes()) {
            row = DefaultSpreadsheetReaderDelegate.findTheFirstNonEmptyRow(iterator);
            if (row != null) {
                new ColumnTypeScanner(sheet).detectColumnTypes(row, iterator, (ColumnType[])columnTypes);
            }
        } else if (this._configuration.getColumnNameLineNumber() == 0) {
            Arrays.fill(columnTypes, DEFAULT_COLUMN_TYPE);
        } else {
            Arrays.fill(columnTypes, LEGACY_COLUMN_TYPE);
        }
        return columnTypes;
    }

    private static Row findTheFirstNonEmptyRow(Iterator<Row> rowIterator) {
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            if (row == null) continue;
            return row;
        }
        return null;
    }

    private void createColumns(MutableTable table, Workbook wb, Row row, ColumnType[] columnTypes) {
        if (row == null) {
            logger.warn("Cannot create columns based on null row!");
            return;
        }
        short rowLength = row.getLastCellNum();
        int offset = this.getColumnOffset(row);
        try (ColumnNamingSession columnNamingSession = this._configuration.getColumnNamingStrategy().startColumnNamingSession();){
            for (int i = offset; i < rowLength; ++i) {
                Cell cell = row.getCell(i);
                String intrinsicColumnName = ExcelUtils.getCellValue(wb, cell);
                ColumnNamingContextImpl columnNamingContext = new ColumnNamingContextImpl((Table)table, intrinsicColumnName, i);
                String columnName = columnNamingSession.getNextColumnName((ColumnNamingContext)columnNamingContext);
                MutableColumn column = new MutableColumn(columnName, columnTypes[i], (Table)table, i, Boolean.valueOf(true));
                table.addColumn((Column)column);
            }
        }
    }

    private int getColumnOffset(Row row) {
        short offset = this._configuration.isSkipEmptyColumns() ? row.getFirstCellNum() : (short)0;
        return offset;
    }

    private class ColumnTypeScanner {
        final FormulaEvaluator formulaEvaluator;

        ColumnTypeScanner(Sheet sheet) {
            this.formulaEvaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }

        private void detectColumnTypes(Row firstRow, Iterator<Row> dataRowIterator, ColumnType[] columnTypes) {
            this.detectColumnTypesFirstRow(firstRow, columnTypes);
            this.detectColumnTypesOtherRows(dataRowIterator, columnTypes);
            for (int i = 0; i < columnTypes.length; ++i) {
                if (columnTypes[i] != null) continue;
                columnTypes[i] = DEFAULT_COLUMN_TYPE;
            }
        }

        private void detectColumnTypesFirstRow(Row firstRow, ColumnType[] columnTypes) {
            if (firstRow != null && firstRow.getLastCellNum() > 0) {
                for (int i = DefaultSpreadsheetReaderDelegate.this.getColumnOffset(firstRow); i < columnTypes.length; ++i) {
                    if (firstRow.getCell(i) == null) continue;
                    columnTypes[i] = this.determineColumnTypeFromCell(firstRow.getCell(i));
                }
            }
        }

        private void detectColumnTypesOtherRows(Iterator<Row> dataRowIterator, ColumnType[] columnTypes) {
            int numberOfLinesToScan = DefaultSpreadsheetReaderDelegate.this._configuration.getNumberOfLinesToScan() - 1;
            while (dataRowIterator.hasNext() && numberOfLinesToScan-- > 0) {
                Row currentRow = dataRowIterator.next();
                if (currentRow == null || currentRow.getLastCellNum() <= 0) continue;
                for (int i = DefaultSpreadsheetReaderDelegate.this.getColumnOffset(currentRow); i < columnTypes.length; ++i) {
                    ColumnType detectNewColumnType = this.detectNewColumnTypeCell(columnTypes[i], currentRow.getCell(i));
                    if (detectNewColumnType == null) continue;
                    columnTypes[i] = detectNewColumnType;
                }
            }
        }

        private ColumnType detectNewColumnTypeCell(ColumnType currentColumnType, Cell cell) {
            if (currentColumnType != null && currentColumnType.equals(DEFAULT_COLUMN_TYPE)) {
                return null;
            }
            if (cell == null) {
                return null;
            }
            ColumnType detectedColumnType = this.determineColumnTypeFromCell(cell);
            if (currentColumnType == null) {
                return detectedColumnType;
            }
            if (!currentColumnType.equals(detectedColumnType)) {
                if (currentColumnType.equals(ColumnType.INTEGER) && detectedColumnType.equals(ColumnType.DOUBLE)) {
                    return detectedColumnType;
                }
                if (currentColumnType.equals(ColumnType.DOUBLE) && detectedColumnType.equals(ColumnType.INTEGER)) {
                    return null;
                }
                return DEFAULT_COLUMN_TYPE;
            }
            return null;
        }

        private ColumnType determineColumnTypeFromCell(Cell cell) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return ColumnType.DATE;
                    }
                    return cell.getNumericCellValue() % 1.0 == 0.0 ? ColumnType.INTEGER : ColumnType.DOUBLE;
                }
                case BOOLEAN: {
                    return ColumnType.BOOLEAN;
                }
                case FORMULA: {
                    return this.determineColumnTypeFromCell(this.formulaEvaluator.evaluateInCell(cell));
                }
            }
            return DEFAULT_COLUMN_TYPE;
        }
    }
}

