/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.excel.ExcelUpdateCallback;
import org.apache.metamodel.excel.ExcelUtils;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Table;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

final class ExcelDeleteBuilder
extends AbstractRowDeletionBuilder {
    private final ExcelUpdateCallback _updateCallback;

    public ExcelDeleteBuilder(ExcelUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        this._updateCallback.close();
        Workbook workbook = this._updateCallback.getWorkbook(false);
        String tableName = this.getTable().getName();
        List selectItems = this.getTable().getColumns().stream().map(SelectItem::new).collect(Collectors.toList());
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        Sheet sheet = workbook.getSheet(tableName);
        Iterator<org.apache.poi.ss.usermodel.Row> rowIterator = ExcelUtils.getRowIterator(sheet, this._updateCallback.getConfiguration(), true);
        ArrayList<org.apache.poi.ss.usermodel.Row> rowsToDelete = new ArrayList<org.apache.poi.ss.usermodel.Row>();
        while (rowIterator.hasNext()) {
            org.apache.poi.ss.usermodel.Row excelRow = rowIterator.next();
            DefaultRow defaultRow = ExcelUtils.createRow(workbook, excelRow, (DataSetHeader)header);
            boolean deleteRow = this.deleteRow((Row)defaultRow);
            if (!deleteRow) continue;
            rowsToDelete.add(excelRow);
        }
        Collections.reverse(rowsToDelete);
        for (org.apache.poi.ss.usermodel.Row row : rowsToDelete) {
            sheet.removeRow(row);
        }
    }
}

