/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.metamodel.fixedwidth.FixedWidthReader;

class EbcdicReader
extends FixedWidthReader {
    private final boolean _skipEbcdicHeader;
    private final boolean _eolPresent;
    private boolean _headerSkipped;

    public EbcdicReader(BufferedInputStream stream, String charsetName, int[] valueWidths, boolean failOnInconsistentLineWidth, boolean skipEbcdicHeader, boolean eolPresent) {
        super(stream, charsetName, valueWidths, failOnInconsistentLineWidth);
        this._skipEbcdicHeader = skipEbcdicHeader;
        this._eolPresent = eolPresent;
    }

    @Override
    protected void beforeReadLine() {
        if (this.shouldSkipHeader()) {
            try {
                this.skipHeader();
            }
            catch (IOException e) {
                throw new IllegalStateException("A problem occurred while skipping the input stream. ", e);
            }
        }
    }

    private boolean shouldSkipHeader() {
        return this._skipEbcdicHeader && !this._headerSkipped;
    }

    private void skipHeader() throws IOException {
        this._headerSkipped = true;
        this._stream.skip(this._expectedLineLength);
    }

    @Override
    protected String readSingleRecordData() throws IOException {
        if (this._eolPresent) {
            return super.readSingleRecordData();
        }
        byte[] buffer = new byte[this._expectedLineLength];
        int bytesRead = this._stream.read(buffer, 0, this._expectedLineLength);
        if (bytesRead < 0) {
            return null;
        }
        return new String(buffer, this._charsetName);
    }
}

