/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.fixedwidth.FixedWidthColumnSpec;
import org.apache.metamodel.schema.naming.ColumnNamingStrategies;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.BaseObject;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.HasNameMapper;

public class FixedWidthConfiguration
extends BaseObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NO_COLUMN_NAME_LINE = 0;
    public static final int DEFAULT_COLUMN_NAME_LINE = 1;
    private final String encoding;
    private final int fixedValueWidth;
    private final int[] valueWidths;
    private final int columnNameLineNumber;
    private final boolean failOnInconsistentLineWidth;
    private final ColumnNamingStrategy columnNamingStrategy;

    public FixedWidthConfiguration(int fixedValueWidth) {
        this(1, "UTF-8", fixedValueWidth);
    }

    public FixedWidthConfiguration(int[] valueWidth) {
        this(1, "UTF-8", valueWidth, false);
    }

    public FixedWidthConfiguration(int columnNameLineNumber, String encoding, int fixedValueWidth) {
        this(columnNameLineNumber, encoding, fixedValueWidth, false);
    }

    public FixedWidthConfiguration(int columnNameLineNumber, String encoding, int fixedValueWidth, boolean failOnInconsistentLineWidth) {
        this.encoding = encoding;
        this.fixedValueWidth = fixedValueWidth;
        this.columnNameLineNumber = columnNameLineNumber;
        this.failOnInconsistentLineWidth = failOnInconsistentLineWidth;
        this.columnNamingStrategy = null;
        this.valueWidths = new int[0];
    }

    public FixedWidthConfiguration(int columnNameLineNumber, String encoding, int[] valueWidths, boolean failOnInconsistentLineWidth) {
        this(columnNameLineNumber, null, encoding, valueWidths, failOnInconsistentLineWidth);
    }

    public FixedWidthConfiguration(int columnNameLineNumber, ColumnNamingStrategy columnNamingStrategy, String encoding, int[] valueWidths, boolean failOnInconsistentLineWidth) {
        this.encoding = encoding;
        this.fixedValueWidth = -1;
        this.columnNameLineNumber = columnNameLineNumber;
        this.failOnInconsistentLineWidth = failOnInconsistentLineWidth;
        this.columnNamingStrategy = columnNamingStrategy;
        this.valueWidths = valueWidths;
    }

    public FixedWidthConfiguration(String encoding, List<FixedWidthColumnSpec> columnSpecs) {
        this(encoding, columnSpecs, false);
    }

    public FixedWidthConfiguration(String encoding, List<FixedWidthColumnSpec> columnSpecs, boolean failOnInconsistentLineWidth) {
        this.encoding = encoding;
        this.fixedValueWidth = -1;
        this.columnNameLineNumber = 0;
        this.columnNamingStrategy = ColumnNamingStrategies.customNames((List)CollectionUtils.map(columnSpecs, (Func)new HasNameMapper()));
        this.valueWidths = new int[columnSpecs.size()];
        for (int i = 0; i < this.valueWidths.length; ++i) {
            this.valueWidths[i] = columnSpecs.get(i).getWidth();
        }
        this.failOnInconsistentLineWidth = failOnInconsistentLineWidth;
    }

    public int getColumnNameLineNumber() {
        return this.columnNameLineNumber;
    }

    public ColumnNamingStrategy getColumnNamingStrategy() {
        if (this.columnNamingStrategy == null) {
            return ColumnNamingStrategies.defaultStrategy();
        }
        return this.columnNamingStrategy;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getFixedValueWidth() {
        return this.fixedValueWidth;
    }

    public int[] getValueWidths() {
        return this.valueWidths;
    }

    public boolean isFailOnInconsistentLineWidth() {
        return this.failOnInconsistentLineWidth;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.columnNameLineNumber);
        identifiers.add(this.encoding);
        identifiers.add(this.fixedValueWidth);
        identifiers.add(this.valueWidths);
        identifiers.add(this.failOnInconsistentLineWidth);
    }

    public String toString() {
        return "FixedWidthConfiguration[encoding=" + this.encoding + ", fixedValueWidth=" + this.fixedValueWidth + ", valueWidths=" + Arrays.toString(this.valueWidths) + ", columnNameLineNumber=" + this.columnNameLineNumber + ", failOnInconsistentLineWidth=" + this.failOnInconsistentLineWidth + "]";
    }

    public boolean isConstantValueWidth() {
        return this.fixedValueWidth != -1;
    }

    public int getValueWidth(int columnIndex) {
        if (this.isConstantValueWidth()) {
            return this.fixedValueWidth;
        }
        return this.valueWidths[columnIndex];
    }
}

