/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.fixedwidth.EbcdicConfiguration;
import org.apache.metamodel.fixedwidth.EbcdicReader;
import org.apache.metamodel.fixedwidth.FixedWidthConfiguration;
import org.apache.metamodel.fixedwidth.FixedWidthDataSet;
import org.apache.metamodel.fixedwidth.FixedWidthReader;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingContextImpl;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceUtils;

public class FixedWidthDataContext
extends QueryPostprocessDataContext {
    private final Resource _resource;
    private final FixedWidthConfiguration _configuration;

    @Deprecated
    public FixedWidthDataContext(String filename, String fileEncoding, int fixedValueWidth) {
        this((Resource)new FileResource(filename), new FixedWidthConfiguration(fixedValueWidth));
    }

    @Deprecated
    public FixedWidthDataContext(File file, String fileEncoding, int fixedValueWidth, int headerLineNumber) {
        this(file, new FixedWidthConfiguration(headerLineNumber, fileEncoding, fixedValueWidth));
    }

    public FixedWidthDataContext(File file, FixedWidthConfiguration configuration) {
        this._resource = new FileResource(file);
        this._configuration = configuration;
    }

    public FixedWidthDataContext(Resource resource, FixedWidthConfiguration configuration) {
        this._resource = resource;
        this._configuration = configuration;
    }

    public FixedWidthConfiguration getConfiguration() {
        return this._configuration;
    }

    @Deprecated
    public File getFile() {
        if (this._resource instanceof FileResource) {
            return ((FileResource)this._resource).getFile();
        }
        return null;
    }

    public Resource getResource() {
        return this._resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getMainSchema() throws MetaModelException {
        String[] columnNames;
        FixedWidthReader reader;
        MutableTable table;
        MutableSchema schema;
        block20: {
            String schemaName = this.getDefaultSchemaName();
            schema = new MutableSchema(schemaName);
            String tableName = this._resource.getName();
            table = new MutableTable(tableName, TableType.TABLE, (Schema)schema);
            schema.addTable(table);
            reader = this.createReader();
            try {
                boolean hasColumnHeader;
                boolean bl = hasColumnHeader = this._configuration.getColumnNameLineNumber() != 0;
                if (hasColumnHeader) {
                    for (int i = 1; i < this._configuration.getColumnNameLineNumber(); ++i) {
                        reader.readLine();
                    }
                    columnNames = reader.readLine();
                } else {
                    columnNames = reader.readLine();
                }
                ColumnNamingStrategy columnNamingStrategy = this._configuration.getColumnNamingStrategy();
                if (columnNames == null) break block20;
                try (ColumnNamingSession columnNamingSession = columnNamingStrategy.startColumnNamingSession();){
                    for (int i = 0; i < columnNames.length; ++i) {
                        String intrinsicColumnName = hasColumnHeader ? columnNames[i] : null;
                        columnNames[i] = columnNamingSession.getNextColumnName((ColumnNamingContext)new ColumnNamingContextImpl((Table)table, intrinsicColumnName, i));
                    }
                }
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        if (columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                MutableColumn column = new MutableColumn(columnName, ColumnType.STRING, (Table)table, i, Boolean.valueOf(true));
                column.setColumnSize(Integer.valueOf(this._configuration.getValueWidth(i)));
                table.addColumn((Column)column);
            }
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return ResourceUtils.getParentName((Resource)this._resource);
    }

    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        FixedWidthReader reader = this.createReader();
        try {
            for (int i = 1; i <= this._configuration.getColumnNameLineNumber(); ++i) {
                reader.readLine();
            }
        }
        catch (IllegalStateException e) {
            FileHelper.safeClose((Object[])new Object[]{reader});
            throw e;
        }
        if (maxRows > 0) {
            return new FixedWidthDataSet(reader, columns, maxRows);
        }
        return new FixedWidthDataSet(reader, columns, null);
    }

    private FixedWidthReader createReader() {
        InputStream inputStream = this._resource.read();
        FixedWidthReader reader = this._configuration instanceof EbcdicConfiguration ? new EbcdicReader((BufferedInputStream)inputStream, this._configuration.getEncoding(), this._configuration.getValueWidths(), this._configuration.isFailOnInconsistentLineWidth(), ((EbcdicConfiguration)this._configuration).isSkipEbcdicHeader(), ((EbcdicConfiguration)this._configuration).isEolPresent()) : (this._configuration.isConstantValueWidth() ? new FixedWidthReader(inputStream, this._configuration.getEncoding(), this._configuration.getFixedValueWidth(), this._configuration.isFailOnInconsistentLineWidth()) : new FixedWidthReader(inputStream, this._configuration.getEncoding(), this._configuration.getValueWidths(), this._configuration.isFailOnInconsistentLineWidth()));
        return reader;
    }
}

