/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.fixedwidth.InconsistentValueWidthException;

class FixedWidthReader
implements Closeable {
    private static final int END_OF_STREAM = -1;
    private static final int LINE_FEED = 10;
    private static final int CARRIAGE_RETURN = 13;
    protected final String _charsetName;
    private final int _fixedValueWidth;
    private final int[] _valueWidths;
    private int _valueIndex = 0;
    private final boolean _failOnInconsistentLineWidth;
    private final boolean _constantWidth;
    private volatile int _rowNumber;
    protected final BufferedInputStream _stream;
    protected final int _expectedLineLength;

    public FixedWidthReader(InputStream stream, String charsetName, int fixedValueWidth, boolean failOnInconsistentLineWidth) {
        this(new BufferedInputStream(stream), charsetName, fixedValueWidth, failOnInconsistentLineWidth);
    }

    private FixedWidthReader(BufferedInputStream stream, String charsetName, int fixedValueWidth, boolean failOnInconsistentLineWidth) {
        this._stream = stream;
        this._charsetName = charsetName;
        this._fixedValueWidth = fixedValueWidth;
        this._failOnInconsistentLineWidth = failOnInconsistentLineWidth;
        this._rowNumber = 0;
        this._valueWidths = null;
        this._constantWidth = true;
        this._expectedLineLength = -1;
    }

    public FixedWidthReader(InputStream stream, String charsetName, int[] valueWidths, boolean failOnInconsistentLineWidth) {
        this(new BufferedInputStream(stream), charsetName, valueWidths, failOnInconsistentLineWidth);
    }

    FixedWidthReader(BufferedInputStream stream, String charsetName, int[] valueWidths, boolean failOnInconsistentLineWidth) {
        this._stream = stream;
        this._charsetName = charsetName;
        this._fixedValueWidth = -1;
        this._valueWidths = valueWidths;
        this._failOnInconsistentLineWidth = failOnInconsistentLineWidth;
        this._rowNumber = 0;
        this._constantWidth = false;
        int expectedLineLength = 0;
        for (int _valueWidth : this._valueWidths) {
            expectedLineLength += _valueWidth;
        }
        this._expectedLineLength = expectedLineLength;
    }

    public String[] readLine() throws IllegalStateException {
        try {
            this.beforeReadLine();
            ++this._rowNumber;
            return this.getValues();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void beforeReadLine() {
    }

    private String[] getValues() throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        String singleRecordData = this.readSingleRecordData();
        if (singleRecordData == null) {
            return null;
        }
        this.processSingleRecordData(singleRecordData, values);
        String[] result = values.toArray(new String[values.size()]);
        if (!this._failOnInconsistentLineWidth && !this._constantWidth) {
            result = this.correctResult(result);
        }
        this.validateConsistentValue(singleRecordData, result, values.size());
        return result;
    }

    private void validateConsistentValue(String recordData, String[] result, int valuesSize) {
        if (!this._failOnInconsistentLineWidth) {
            return;
        }
        InconsistentValueWidthException inconsistentValueException = null;
        if (this._constantWidth) {
            if (recordData.length() % this._fixedValueWidth != 0) {
                inconsistentValueException = new InconsistentValueWidthException(result, recordData, this._rowNumber);
            }
        } else if (result.length != valuesSize || recordData.length() != this._expectedLineLength) {
            inconsistentValueException = new InconsistentValueWidthException(result, recordData, this._rowNumber);
        }
        if (inconsistentValueException != null) {
            throw inconsistentValueException;
        }
    }

    private void processSingleRecordData(String singleRecordData, List<String> values) {
        StringBuilder nextValue = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(singleRecordData);
        this._valueIndex = 0;
        char c = it.first();
        while (c != '\uffff') {
            this.processCharacter(c, nextValue, values, singleRecordData);
            c = it.next();
        }
        if (nextValue.length() > 0) {
            this.addNewValueIfAppropriate(values, nextValue);
        }
    }

    String readSingleRecordData() throws IOException {
        StringBuilder line = new StringBuilder();
        int ch = this._stream.read();
        while (!this.isEndingCharacter(ch)) {
            line.append((char)ch);
            ch = this._stream.read();
        }
        if (ch == 13) {
            this.readLineFeedIfFollows();
        }
        return line.length() > 0 ? line.toString() : null;
    }

    private void readLineFeedIfFollows() throws IOException {
        this._stream.mark(1);
        if (this._stream.read() != 10) {
            this._stream.reset();
        }
    }

    private boolean isEndingCharacter(int ch) {
        return ch == 13 || ch == 10 || ch == -1;
    }

    private void processCharacter(char c, StringBuilder nextValue, List<String> values, String recordData) {
        nextValue.append(c);
        int valueWidth = this.getValueWidth(values, recordData);
        if (nextValue.length() == valueWidth) {
            this.addNewValueIfAppropriate(values, nextValue);
            nextValue.setLength(0);
            if (this._valueWidths != null) {
                this._valueIndex = (this._valueIndex + 1) % this._valueWidths.length;
            }
        }
    }

    private int getValueWidth(List<String> values, String recordData) {
        if (this._constantWidth) {
            return this._fixedValueWidth;
        }
        if (this._valueIndex >= this._valueWidths.length) {
            if (this._failOnInconsistentLineWidth) {
                String[] result = values.toArray(new String[values.size()]);
                throw new InconsistentValueWidthException(result, recordData, this._rowNumber + 1);
            }
            return -1;
        }
        return this._valueWidths[this._valueIndex];
    }

    private void addNewValueIfAppropriate(List<String> values, StringBuilder nextValue) {
        if (this._valueWidths != null) {
            if (values.size() < this._valueWidths.length) {
                values.add(nextValue.toString().trim());
            }
        } else {
            values.add(nextValue.toString().trim());
        }
    }

    private String[] correctResult(String[] result) {
        if (result.length != this._valueWidths.length) {
            String[] correctedResult = new String[this._valueWidths.length];
            for (int i = 0; i < result.length && i < this._valueWidths.length; ++i) {
                correctedResult[i] = result[i];
            }
            result = correctedResult;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this._stream.close();
    }
}

