/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.util.ArrayList;
import java.util.Map;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.fixedwidth.FixedWidthColumnSpec;
import org.apache.metamodel.fixedwidth.FixedWidthConfiguration;
import org.apache.metamodel.fixedwidth.FixedWidthDataContext;
import org.apache.metamodel.util.Resource;

public class FixedWidthDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "fixed-width";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        assert (this.accepts(properties, resourceFactoryRegistry));
        Resource resource = resourceFactoryRegistry.createResource(properties.getResourceProperties());
        String encoding = this.getString(properties.getEncoding(), "UTF-8");
        boolean failOnInconsistentRowLength = this.getBoolean(properties.isFailOnInconsistentRowLength(), false);
        ArrayList<FixedWidthColumnSpec> columnSpecs = new ArrayList<FixedWidthColumnSpec>();
        Object columns = properties.toMap().get("columns");
        if (columns instanceof Map) {
            ((Map)columns).forEach((k, v) -> {
                String name = k;
                int width = ((Number)v).intValue();
                columnSpecs.add(new FixedWidthColumnSpec(name, width));
            });
        } else if (columns instanceof String) {
            String[] split = ((String)columns).split(",");
            String nextName = null;
            for (String token : split) {
                try {
                    int width = Integer.parseInt(token);
                    columnSpecs.add(new FixedWidthColumnSpec(nextName, width));
                    nextName = null;
                }
                catch (NumberFormatException e) {
                    nextName = token;
                }
            }
        }
        FixedWidthConfiguration configuration = new FixedWidthConfiguration(encoding, columnSpecs, failOnInconsistentRowLength);
        return new FixedWidthDataContext(resource, configuration);
    }
}

