/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import org.apache.metamodel.fixedwidth.FixedWidthConfiguration;
import org.apache.metamodel.fixedwidth.InconsistentValueWidthException;

public class FixedWidthLineParser {
    private final int _expectedLineLength;
    private volatile int _rowNumber;
    private final FixedWidthConfiguration _configuration;

    public FixedWidthLineParser(FixedWidthConfiguration configuration, int expectedLineLength, int rowNumber) {
        this._configuration = configuration;
        this._expectedLineLength = expectedLineLength;
        this._rowNumber = rowNumber;
    }

    public String[] parseLine(String line) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        int[] valueWidths = this._configuration.getValueWidths();
        if (line == null) {
            return null;
        }
        StringBuilder nextValue = new StringBuilder();
        int valueIndex = 0;
        StringCharacterIterator it = new StringCharacterIterator(line);
        char c = it.first();
        while (c != '\uffff') {
            int valueWidth;
            nextValue.append(c);
            if (this._configuration.isConstantValueWidth()) {
                valueWidth = this._configuration.getFixedValueWidth();
            } else {
                if (valueIndex >= valueWidths.length) {
                    if (!this._configuration.isFailOnInconsistentLineWidth()) break;
                    String[] result = values.toArray(new String[values.size()]);
                    throw new InconsistentValueWidthException(result, line, this._rowNumber + 1);
                }
                valueWidth = this._configuration.getValueWidth(valueIndex);
            }
            if (nextValue.length() == valueWidth) {
                values.add(nextValue.toString().trim());
                nextValue = new StringBuilder();
                ++valueIndex;
            }
            c = it.next();
        }
        if (nextValue.length() > 0) {
            values.add(nextValue.toString().trim());
        }
        String[] result = values.toArray(new String[values.size()]);
        if (!this._configuration.isFailOnInconsistentLineWidth() && !this._configuration.isConstantValueWidth() && result.length != valueWidths.length) {
            String[] correctedResult = new String[valueWidths.length];
            for (int i = 0; i < result.length && i < valueWidths.length; ++i) {
                correctedResult[i] = result[i];
            }
            result = correctedResult;
        }
        if (this._configuration.isFailOnInconsistentLineWidth()) {
            ++this._rowNumber;
            if (this._configuration.isConstantValueWidth()) {
                if (line.length() % this._configuration.getFixedValueWidth() != 0) {
                    throw new InconsistentValueWidthException(result, line, this._rowNumber);
                }
            } else {
                if (result.length != values.size()) {
                    throw new InconsistentValueWidthException(result, line, this._rowNumber);
                }
                if (line.length() != this._expectedLineLength) {
                    throw new InconsistentValueWidthException(result, line, this._rowNumber);
                }
            }
        }
        return result;
    }
}

