/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import com.datastax.driver.core.Cluster;
import com.google.common.base.Strings;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import io.searchbox.client.JestClient;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.metamodel.CompositeDataContext;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.cassandra.CassandraDataContext;
import org.apache.metamodel.couchdb.CouchDbDataContext;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelDataContext;
import org.apache.metamodel.fixedwidth.FixedWidthConfiguration;
import org.apache.metamodel.fixedwidth.FixedWidthDataContext;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.json.JsonDataContext;
import org.apache.metamodel.mongodb.mongo3.MongoDbDataContext;
import org.apache.metamodel.openoffice.OpenOfficeDataContext;
import org.apache.metamodel.salesforce.SalesforceDataContext;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.sugarcrm.SugarCrmDataContext;
import org.apache.metamodel.util.SimpleTableDef;
import org.apache.metamodel.xml.XmlDomDataContext;
import org.ektorp.http.StdHttpClient;
import org.elasticsearch.client.Client;
import org.xml.sax.InputSource;

public class DataContextFactory {
    public static final char DEFAULT_CSV_SEPARATOR_CHAR = ',';
    public static final char DEFAULT_CSV_QUOTE_CHAR = '\"';

    private DataContextFactory() {
    }

    public static DataContext createCompositeDataContext(DataContext ... delegates) {
        return new CompositeDataContext(delegates);
    }

    public static DataContext createCompositeDataContext(Collection<DataContext> delegates) {
        return new CompositeDataContext(delegates);
    }

    public static DataContext createSalesforceDataContext(String username, String password, String securityToken) {
        return new SalesforceDataContext(username, password, securityToken);
    }

    public static DataContext createSugarCrmDataContext(String baseUrl, String username, String password, String applicationName) {
        return new SugarCrmDataContext(baseUrl, username, password, applicationName);
    }

    public static UpdateableDataContext createCsvDataContext(File file) {
        return DataContextFactory.createCsvDataContext(file, ',', '\"');
    }

    public static DataContext createJsonDataContext(File file) {
        return new JsonDataContext(file);
    }

    public static UpdateableDataContext createCsvDataContext(File file, char separatorChar, char quoteChar) {
        return DataContextFactory.createCsvDataContext(file, separatorChar, quoteChar, "UTF-8");
    }

    public static UpdateableDataContext createCsvDataContext(File file, char separatorChar, char quoteChar, String encoding) {
        CsvConfiguration configuration = new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\');
        CsvDataContext dc = new CsvDataContext(file, configuration);
        return dc;
    }

    public static UpdateableDataContext createCsvDataContext(File file, CsvConfiguration configuration) {
        CsvDataContext dc = new CsvDataContext(file, configuration);
        return dc;
    }

    public static DataContext createCsvDataContext(InputStream inputStream, char separatorChar, char quoteChar) {
        return DataContextFactory.createCsvDataContext(inputStream, separatorChar, quoteChar, "UTF-8");
    }

    public static DataContext createCsvDataContext(InputStream inputStream, char separatorChar, char quoteChar, String encoding) {
        CsvConfiguration configuration = new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\');
        CsvDataContext dc = new CsvDataContext(inputStream, configuration);
        return dc;
    }

    public static DataContext createCsvDataContext(InputStream inputStream, CsvConfiguration configuration) {
        CsvDataContext dc = new CsvDataContext(inputStream, configuration);
        return dc;
    }

    public static DataContext createFixedWidthDataContext(File file, String fileEncoding, int fixedValueWidth) {
        return DataContextFactory.createFixedWidthDataContext(file, new FixedWidthConfiguration(1, fileEncoding, fixedValueWidth));
    }

    public static DataContext createFixedWidthDataContext(File file, FixedWidthConfiguration configuration) {
        FixedWidthDataContext dc = new FixedWidthDataContext(file, configuration);
        return dc;
    }

    public static DataContext createFixedWidthDataContext(File file, String fileEncoding, int fixedValueWidth, int headerLineNumber) {
        return DataContextFactory.createFixedWidthDataContext(file, new FixedWidthConfiguration(1, fileEncoding, fixedValueWidth));
    }

    public static UpdateableDataContext createExcelDataContext(File file, ExcelConfiguration configuration) {
        return new ExcelDataContext(file, configuration);
    }

    public static UpdateableDataContext createExcelDataContext(File file) {
        return DataContextFactory.createExcelDataContext(file, new ExcelConfiguration());
    }

    public static DataContext createXmlDataContext(InputSource inputSource, String schemaName, boolean autoFlattenTables) {
        XmlDomDataContext dc = new XmlDomDataContext(inputSource, schemaName, autoFlattenTables);
        return dc;
    }

    public static DataContext createXmlDataContext(File file, boolean autoFlattenTables) {
        XmlDomDataContext dc = new XmlDomDataContext(file, autoFlattenTables);
        return dc;
    }

    public static DataContext createXmlDataContext(URL url, boolean autoFlattenTables) {
        XmlDomDataContext dc = new XmlDomDataContext(url, autoFlattenTables);
        return dc;
    }

    public static DataContext createOpenOfficeDataContext(File file) {
        return new OpenOfficeDataContext(file);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection) {
        return new JdbcDataContext(connection);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds) {
        return new JdbcDataContext(ds);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection, String catalogName) {
        return new JdbcDataContext(connection, TableType.DEFAULT_TABLE_TYPES, catalogName);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection, TableType ... tableTypes) {
        return new JdbcDataContext(connection, tableTypes, null);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection, String catalogName, TableType[] tableTypes) {
        return new JdbcDataContext(connection, tableTypes, catalogName);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds, TableType ... tableTypes) {
        return new JdbcDataContext(ds, tableTypes, null);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds, String catalogName, TableType[] tableTypes) {
        return new JdbcDataContext(ds, tableTypes, catalogName);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds, String catalogName) {
        return new JdbcDataContext(ds, TableType.DEFAULT_TABLE_TYPES, catalogName);
    }

    public static UpdateableDataContext createMongoDbDataContext(String hostname, Integer port, String databaseName, String username, char[] password, SimpleTableDef[] tableDefs) {
        try {
            ServerAddress serverAddress = port == null ? new ServerAddress(hostname) : new ServerAddress(hostname, port.intValue());
            MongoClient mongoClient = null;
            if (Strings.isNullOrEmpty((String)username)) {
                mongoClient = new MongoClient(serverAddress);
            } else {
                MongoCredential credential = MongoCredential.createCredential((String)username, (String)databaseName, (char[])password);
                mongoClient = new MongoClient(serverAddress, Arrays.asList(credential));
            }
            MongoDatabase mongoDb = mongoClient.getDatabase(databaseName);
            if (tableDefs == null || tableDefs.length == 0) {
                return new MongoDbDataContext(mongoDb);
            }
            return new MongoDbDataContext(mongoDb, tableDefs);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    public static UpdateableDataContext createMongoDbDataContext(String hostname, Integer port, String databaseName, String username, char[] password) {
        return DataContextFactory.createMongoDbDataContext(hostname, port, databaseName, username, password, null);
    }

    public static UpdateableDataContext createCouchDbDataContext(String hostname, Integer port, String username, String password) {
        return DataContextFactory.createCouchDbDataContext(hostname, port, username, password, null);
    }

    public static UpdateableDataContext createCouchDbDataContext(String hostname, Integer port, String username, String password, SimpleTableDef[] tableDefs) {
        StdHttpClient.Builder httpClientBuilder = new StdHttpClient.Builder();
        httpClientBuilder.host(hostname);
        if (port != null) {
            httpClientBuilder.port(port.intValue());
        }
        if (username != null) {
            httpClientBuilder.username(username);
        }
        if (password != null) {
            httpClientBuilder.password(password);
        }
        httpClientBuilder.connectionTimeout(20000);
        httpClientBuilder.socketTimeout(20000);
        if (tableDefs == null || tableDefs.length == 0) {
            return new CouchDbDataContext(httpClientBuilder);
        }
        return new CouchDbDataContext(httpClientBuilder, tableDefs);
    }

    public static UpdateableDataContext createElasticSearchDataContext(JestClient client, String indexName) {
        return new ElasticSearchRestDataContext(client, indexName);
    }

    public static UpdateableDataContext createElasticSearchDataContext(Client client, String indexName) {
        return new ElasticSearchDataContext(client, indexName);
    }

    public static DataContext createCassandraDataContext(Cluster cluster, String keySpaceName) {
        return new CassandraDataContext(cluster, keySpaceName);
    }
}

