/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;

public class HdfsResource
implements Resource {
    private static final Pattern URL_PATTERN = Pattern.compile("hdfs://(.+):([0-9]+)/(.*)");
    private final String _hostname;
    private final int _port;
    private final String _filepath;
    private Path _path;

    public HdfsResource(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Url cannot be null");
        }
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Cannot parse url '" + url + "'. Must follow pattern: hdfs://hostname:port/path/to/file");
        }
        this._hostname = matcher.group(1);
        this._port = Integer.parseInt(matcher.group(2));
        this._filepath = '/' + matcher.group(3);
    }

    public HdfsResource(String hostname, int port, String filepath) {
        this._hostname = hostname;
        this._port = port;
        this._filepath = filepath;
    }

    public String getName() {
        int lastSlash = this._filepath.lastIndexOf(47);
        if (lastSlash != -1) {
            return this._filepath.substring(lastSlash + 1);
        }
        return this._filepath;
    }

    public String getQualifiedPath() {
        return "hdfs://" + this._hostname + ":" + this._port + this._filepath;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isExists() {
        boolean bl;
        FileSystem fs = this.getHadoopFileSystem();
        try {
            bl = fs.exists(this.getHadoopPath());
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
        return bl;
    }

    public long getSize() {
        long l;
        FileSystem fs = this.getHadoopFileSystem();
        try {
            l = fs.getFileStatus(this.getHadoopPath()).getLen();
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
        return l;
    }

    public long getLastModified() {
        long l;
        FileSystem fs = this.getHadoopFileSystem();
        try {
            l = fs.getFileStatus(this.getHadoopPath()).getModificationTime();
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Action<OutputStream> writeCallback) throws ResourceException {
        FileSystem fs = this.getHadoopFileSystem();
        try {
            FSDataOutputStream out = fs.create(this.getHadoopPath(), true);
            try {
                writeCallback.run((Object)out);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{out});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{out});
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Action<OutputStream> appendCallback) throws ResourceException {
        FileSystem fs = this.getHadoopFileSystem();
        try {
            FSDataOutputStream out = fs.append(this.getHadoopPath());
            try {
                appendCallback.run((Object)out);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{out});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{out});
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
    }

    public InputStream read() throws ResourceException {
        FSDataInputStream in;
        FileSystem fs = this.getHadoopFileSystem();
        try {
            in = fs.open(this.getHadoopPath());
        }
        catch (Exception e) {
            FileHelper.safeClose((Object[])new Object[]{fs});
            throw this.wrapException(e);
        }
        return new InputStream((InputStream)in, fs){
            final /* synthetic */ InputStream val$in;
            final /* synthetic */ FileSystem val$fs;
            {
                this.val$in = inputStream;
                this.val$fs = fileSystem;
            }

            @Override
            public int read() throws IOException {
                return this.val$in.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.val$in.read(b, off, len);
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.val$in.read(b);
            }

            @Override
            public boolean markSupported() {
                return this.val$in.markSupported();
            }

            @Override
            public synchronized void mark(int readlimit) {
                this.val$in.mark(readlimit);
            }

            @Override
            public int available() throws IOException {
                return this.val$in.available();
            }

            @Override
            public synchronized void reset() throws IOException {
                this.val$in.reset();
            }

            @Override
            public long skip(long n) throws IOException {
                return this.val$in.skip(n);
            }

            @Override
            public void close() throws IOException {
                super.close();
                FileHelper.safeClose((Object[])new Object[]{this.val$fs});
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Action<InputStream> readCallback) throws ResourceException {
        FileSystem fs = this.getHadoopFileSystem();
        try {
            FSDataInputStream in = fs.open(this.getHadoopPath());
            try {
                readCallback.run((Object)in);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{in});
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <E> E read(Func<InputStream, E> readCallback) throws ResourceException {
        FileSystem fs = this.getHadoopFileSystem();
        FSDataInputStream in = fs.open(this.getHadoopPath());
        Object object = readCallback.eval((Object)in);
        FileHelper.safeClose((Object[])new Object[]{in});
        FileHelper.safeClose((Object[])new Object[]{fs});
        return (E)object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        FileHelper.safeClose((Object[])new Object[]{in});
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw this.wrapException(e);
                    }
                }
                catch (Throwable throwable2) {
                    FileHelper.safeClose((Object[])new Object[]{fs});
                    throw throwable2;
                }
            }
        }
    }

    private RuntimeException wrapException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new MetaModelException(e);
    }

    public Configuration getHadoopConfiguration() {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hdfs://" + this._hostname + ":" + this._port);
        return conf;
    }

    public FileSystem getHadoopFileSystem() {
        try {
            return FileSystem.get((Configuration)this.getHadoopConfiguration());
        }
        catch (IOException e) {
            throw new MetaModelException("Could not connect to HDFS: " + e.getMessage(), (Exception)e);
        }
    }

    public Path getHadoopPath() {
        if (this._path == null) {
            this._path = new Path(this._filepath);
        }
        return this._path;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this._filepath, this._hostname, this._port});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HdfsResource other = (HdfsResource)obj;
        if (this._filepath == null ? other._filepath != null : !this._filepath.equals(other._filepath)) {
            return false;
        }
        if (this._hostname == null ? other._hostname != null : !this._hostname.equals(other._hostname)) {
            return false;
        }
        return this._port == other._port;
    }
}

