/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.util.AbstractResource;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.HdfsDirectoryInputStream;
import org.apache.metamodel.util.HdfsFileInputStream;
import org.apache.metamodel.util.HdfsFileOutputStream;
import org.apache.metamodel.util.ResourceException;

public class HdfsResource
extends AbstractResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SYSTEM_PROPERTY_HADOOP_CONF_DIR_ENABLED = "metamodel.hadoop.use_hadoop_conf_dir";
    public static final String SCHEME_HDFS = "hdfs";
    public static final String SCHEME_SWIFT = "swift";
    public static final String SCHEME_EMRFS = "emrfs";
    public static final String SCHEME_MAPRFS = "maprfs";
    public static final String SCHEME_S3 = "s3";
    public static final String SCHEME_FTP = "ftp";
    private final String _scheme;
    private final String _hadoopConfDir;
    private final String _hostname;
    private final int _port;
    private final String _filepath;
    private transient Path _path;

    public HdfsResource(String url) {
        this(url, null);
    }

    public HdfsResource(String url, String hadoopConfDir) {
        if (url == null) {
            throw new IllegalArgumentException("Url cannot be null");
        }
        URI uri = URI.create(url);
        this._scheme = uri.getScheme();
        this._hostname = uri.getHost();
        this._port = uri.getPort();
        this._filepath = uri.getPath();
        this._hadoopConfDir = hadoopConfDir;
    }

    public HdfsResource(String hostname, int port, String filepath) {
        this(SCHEME_HDFS, hostname, port, filepath, null);
    }

    public HdfsResource(String scheme, String hostname, int port, String filepath, String hadoopConfDir) {
        this._scheme = scheme;
        this._hostname = hostname;
        this._port = port;
        this._filepath = filepath;
        this._hadoopConfDir = hadoopConfDir;
    }

    public String getScheme() {
        if (this._scheme == null) {
            return SCHEME_HDFS;
        }
        return this._scheme;
    }

    public String getFilepath() {
        return this._filepath;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public String getHadoopConfDir() {
        return this._hadoopConfDir;
    }

    public String getName() {
        int lastSlash = this._filepath.lastIndexOf(47);
        if (lastSlash != -1) {
            return this._filepath.substring(lastSlash + 1);
        }
        return this._filepath;
    }

    public String getQualifiedPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getScheme());
        sb.append("://");
        if (this._hostname != null) {
            sb.append(this._hostname);
        }
        if (this._port > 0) {
            sb.append(':');
            sb.append(this._port);
        }
        sb.append(this._filepath);
        return sb.toString();
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isExists() {
        boolean bl;
        FileSystem fs = this.getHadoopFileSystem();
        try {
            bl = fs.exists(this.getHadoopPath());
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
        return bl;
    }

    public long getSize() {
        long l;
        FileSystem fs;
        block5: {
            fs = this.getHadoopFileSystem();
            if (!fs.getFileStatus(this.getHadoopPath()).isFile()) break block5;
            long l2 = fs.getFileStatus(this.getHadoopPath()).getLen();
            FileHelper.safeClose((Object[])new Object[]{fs});
            return l2;
        }
        try {
            l = fs.getContentSummary(this.getHadoopPath()).getLength();
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
        return l;
    }

    public long getLastModified() {
        long l;
        FileSystem fs = this.getHadoopFileSystem();
        try {
            l = fs.getFileStatus(this.getHadoopPath()).getModificationTime();
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fs});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{fs});
        return l;
    }

    public OutputStream write() throws ResourceException {
        FileSystem fs = this.getHadoopFileSystem();
        try {
            FSDataOutputStream out = fs.create(this.getHadoopPath(), true);
            return new HdfsFileOutputStream((OutputStream)out, fs);
        }
        catch (IOException e) {
            FileHelper.safeClose((Object[])new Object[]{fs});
            throw this.wrapException(e);
        }
    }

    public OutputStream append() throws ResourceException {
        FileSystem fs = this.getHadoopFileSystem();
        try {
            FSDataOutputStream out = fs.append(this.getHadoopPath());
            return new HdfsFileOutputStream((OutputStream)out, fs);
        }
        catch (IOException e) {
            FileHelper.safeClose((Object[])new Object[]{fs});
            throw this.wrapException(e);
        }
    }

    public InputStream read() throws ResourceException {
        FileSystem fs = this.getHadoopFileSystem();
        try {
            Path hadoopPath = this.getHadoopPath();
            if (fs.getFileStatus(hadoopPath).isFile()) {
                FSDataInputStream in = fs.open(hadoopPath);
                return new HdfsFileInputStream((InputStream)in, fs);
            }
            return new HdfsDirectoryInputStream(hadoopPath, fs);
        }
        catch (Exception e) {
            FileHelper.safeClose((Object[])new Object[]{fs});
            throw this.wrapException(e);
        }
    }

    private RuntimeException wrapException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new MetaModelException(e);
    }

    public Configuration getHadoopConfiguration() {
        File hadoopConfigurationDirectory;
        Configuration conf = new Configuration();
        if (this._hostname != null && this._port > 0) {
            conf.set("fs.defaultFS", this.getScheme() + "://" + this._hostname + ":" + this._port);
        }
        if ((hadoopConfigurationDirectory = this.getHadoopConfigurationDirectoryToUse()) != null) {
            this.addResourceIfExists(conf, hadoopConfigurationDirectory, "core-site.xml");
            this.addResourceIfExists(conf, hadoopConfigurationDirectory, "hdfs-site.xml");
        }
        return conf;
    }

    private void addResourceIfExists(Configuration conf, File hadoopConfigurationDirectory, String filename) {
        File file = new File(hadoopConfigurationDirectory, filename);
        if (file.exists()) {
            InputStream inputStream = FileHelper.getInputStream((File)file);
            conf.addResource(inputStream, filename);
        }
    }

    private File getHadoopConfigurationDirectoryToUse() {
        File candidate = this.getDirectoryIfExists(null, this._hadoopConfDir);
        if ("true".equals(System.getProperty(SYSTEM_PROPERTY_HADOOP_CONF_DIR_ENABLED))) {
            candidate = this.getDirectoryIfExists(candidate, System.getProperty("YARN_CONF_DIR"));
            candidate = this.getDirectoryIfExists(candidate, System.getProperty("HADOOP_CONF_DIR"));
            candidate = this.getDirectoryIfExists(candidate, System.getenv("YARN_CONF_DIR"));
            candidate = this.getDirectoryIfExists(candidate, System.getenv("HADOOP_CONF_DIR"));
        }
        return candidate;
    }

    private File getDirectoryIfExists(File existingCandidate, String path) {
        File directory;
        if (existingCandidate != null) {
            return existingCandidate;
        }
        if (!Strings.isNullOrEmpty((String)path) && (directory = new File(path)).exists() && directory.isDirectory()) {
            return directory;
        }
        return null;
    }

    public FileSystem getHadoopFileSystem() {
        try {
            return FileSystem.newInstance((Configuration)this.getHadoopConfiguration());
        }
        catch (IOException e) {
            throw new MetaModelException("Could not connect to HDFS: " + e.getMessage(), (Exception)e);
        }
    }

    public Path getHadoopPath() {
        if (this._path == null) {
            this._path = new Path(this._filepath);
        }
        return this._path;
    }

    public int hashCode() {
        return Objects.hash(this.getScheme(), this._filepath, this._hostname, this._port, this._hadoopConfDir);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HdfsResource) {
            HdfsResource other = (HdfsResource)obj;
            return Objects.equals(this.getScheme(), other.getScheme()) && Objects.equals(this._filepath, other._filepath) && Objects.equals(this._hostname, other._hostname) && Objects.equals(this._port, other._port) && Objects.equals(this._hadoopConfDir, other._hadoopConfDir);
        }
        return false;
    }
}

