/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.hbase.ByteUtils;
import org.apache.metamodel.hbase.HBaseConfiguration;
import org.apache.metamodel.hbase.HBaseDataSet;
import org.apache.metamodel.hbase.HBaseRow;
import org.apache.metamodel.hbase.HBaseTable;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseDataContext
extends QueryPostprocessDataContext {
    private static final Logger logger = LoggerFactory.getLogger(HBaseDataContext.class);
    public static final String FIELD_ID = "_id";
    private final HBaseConfiguration _configuration;
    private final HBaseAdmin _admin;
    private final HTablePool _tablePool;

    public HBaseDataContext(HBaseConfiguration configuration) {
        Configuration config = this.createConfig(configuration);
        this._configuration = configuration;
        this._admin = this.createHbaseAdmin(config);
        this._tablePool = new HTablePool(config, 100);
    }

    public HBaseDataContext(HBaseConfiguration configuration, HBaseAdmin admin, HTablePool hTablePool) {
        this._configuration = configuration;
        this._tablePool = hTablePool;
        this._admin = admin;
    }

    private HBaseAdmin createHbaseAdmin(Configuration config) {
        try {
            return new HBaseAdmin(config);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MetaModelException(e);
        }
    }

    private Configuration createConfig(HBaseConfiguration configuration) {
        Configuration config = org.apache.hadoop.hbase.HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", configuration.getZookeeperHostname());
        config.set("hbase.zookeeper.property.clientPort", Integer.toString(configuration.getZookeeperPort()));
        return config;
    }

    public HTablePool getTablePool() {
        return this._tablePool;
    }

    public HBaseAdmin getHBaseAdmin() {
        return this._admin;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this._configuration.getSchemaName());
        try {
            SimpleTableDef[] tableDefinitions = this._configuration.getTableDefinitions();
            if (tableDefinitions == null) {
                HTableDescriptor[] tables = this._admin.listTables();
                tableDefinitions = new SimpleTableDef[tables.length];
                for (int i = 0; i < tables.length; ++i) {
                    SimpleTableDef emptyTableDef;
                    tableDefinitions[i] = emptyTableDef = new SimpleTableDef(tables[i].getNameAsString(), new String[0]);
                }
            }
            for (SimpleTableDef tableDef : tableDefinitions) {
                schema.addTable((MutableTable)new HBaseTable(tableDef, schema, this._admin, this._configuration.getDefaultRowKeyType()));
            }
            return schema;
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public HBaseConfiguration getConfiguration() {
        return this._configuration;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._configuration.getSchemaName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (whereItems != null && !whereItems.isEmpty()) {
            return null;
        }
        long result = 0L;
        HTableInterface hTable = this._tablePool.getTable(table.getName());
        try {
            ResultScanner scanner = hTable.getScanner(new Scan());
            try {
                while (scanner.next() != null) {
                    ++result;
                }
            }
            finally {
                scanner.close();
            }
            return result;
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        HBaseRow hBaseRow;
        HTableInterface hTable = this._tablePool.getTable(table.getName());
        Get get = new Get(ByteUtils.toBytes(keyValue));
        try {
            HBaseRow row;
            Result result = hTable.get(get);
            SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
            hBaseRow = row = new HBaseRow((DataSetHeader)header, result);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Failed to execute HBase get operation with " + primaryKeyColumn.getName() + " = " + keyValue, e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{hTable});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{hTable});
        return hBaseRow;
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        Scan scan = new Scan();
        for (Column column : columns) {
            if (column.isPrimaryKey()) continue;
            int colonIndex = column.getName().indexOf(58);
            if (colonIndex != -1) {
                String family = column.getName().substring(0, colonIndex);
                scan.addFamily(family.getBytes());
                continue;
            }
            scan.addFamily(column.getName().getBytes());
        }
        if (maxRows > 0) {
            this.setMaxRows(scan, maxRows);
        }
        HTableInterface hTable = this._tablePool.getTable(table.getName());
        try {
            ResultScanner scanner = hTable.getScanner(scan);
            return new HBaseDataSet(columns, scanner, hTable);
        }
        catch (Exception e) {
            FileHelper.safeClose((Object[])new Object[]{hTable});
            throw new MetaModelException(e);
        }
    }

    private void setMaxRows(Scan scan, int maxRows) {
        try {
            Method method = scan.getClass().getMethod("setMaxResultSize", Long.TYPE);
            method.invoke((Object)scan, maxRows);
            logger.debug("Succesfully set maxRows using Scan.setMaxResultSize({})", (Object)maxRows);
        }
        catch (Exception e) {
            logger.debug("HBase API does not have Scan.setMaxResultSize(long) method, setting maxRows using PageFilter.", (Throwable)e);
            scan.setFilter((Filter)new PageFilter((long)maxRows));
        }
    }
}

