/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.hbase.ByteUtils;
import org.apache.metamodel.hbase.HBaseConfiguration;
import org.apache.metamodel.hbase.HBaseDataSet;
import org.apache.metamodel.hbase.HBaseRow;
import org.apache.metamodel.hbase.HBaseTable;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseDataContext
extends QueryPostprocessDataContext {
    private static final Logger logger = LoggerFactory.getLogger(HBaseDataContext.class);
    public static final String FIELD_ID = "_id";
    private final HBaseConfiguration _configuration;
    private final Connection _connection;

    public HBaseDataContext(HBaseConfiguration configuration) {
        Configuration config = this.createConfig(configuration);
        this._configuration = configuration;
        this._connection = this.createConnection(config);
    }

    public HBaseDataContext(HBaseConfiguration configuration, Connection connection) {
        this._configuration = configuration;
        this._connection = connection;
    }

    private Connection createConnection(Configuration config) {
        try {
            return ConnectionFactory.createConnection((Configuration)config);
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    private Configuration createConfig(HBaseConfiguration configuration) {
        Configuration config = org.apache.hadoop.hbase.HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", configuration.getZookeeperHostname());
        config.set("hbase.zookeeper.property.clientPort", Integer.toString(configuration.getZookeeperPort()));
        config.set("hbase.client.retries.number", Integer.toString(configuration.getHBaseClientRetries()));
        config.set("zookeeper.session.timeout", Integer.toString(configuration.getZookeeperSessionTimeout()));
        config.set("zookeeper.recovery.retry", Integer.toString(configuration.getZookeeperRecoveryRetries()));
        return config;
    }

    public Admin getAdmin() {
        try {
            return this._connection.getAdmin();
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    public Connection getConnection() {
        return this._connection;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this._configuration.getSchemaName());
        try {
            SimpleTableDef[] tableDefinitions = this._configuration.getTableDefinitions();
            if (tableDefinitions == null) {
                HTableDescriptor[] tables = this.getAdmin().listTables();
                tableDefinitions = new SimpleTableDef[tables.length];
                for (int i = 0; i < tables.length; ++i) {
                    SimpleTableDef emptyTableDef;
                    tableDefinitions[i] = emptyTableDef = new SimpleTableDef(tables[i].getNameAsString(), new String[0]);
                }
            }
            for (SimpleTableDef tableDef : tableDefinitions) {
                schema.addTable((MutableTable)new HBaseTable(this, tableDef, schema, this._configuration.getDefaultRowKeyType()));
            }
            return schema;
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public HBaseConfiguration getConfiguration() {
        return this._configuration;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._configuration.getSchemaName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Number executeCountQuery(org.apache.metamodel.schema.Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (whereItems != null && !whereItems.isEmpty()) {
            return null;
        }
        long result = 0L;
        Table hTable = this.getHTable(table.getName());
        try {
            ResultScanner scanner = hTable.getScanner(new Scan());
            try {
                while (scanner.next() != null) {
                    ++result;
                }
            }
            finally {
                scanner.close();
            }
            return result;
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    protected Table getHTable(String name) {
        try {
            TableName tableName = TableName.valueOf((String)name);
            Table hTable = this._connection.getTable(tableName);
            return hTable;
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    protected Row executePrimaryKeyLookupQuery(org.apache.metamodel.schema.Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        HBaseRow hBaseRow;
        Table hTable = this.getHTable(table.getName());
        Get get = new Get(ByteUtils.toBytes(keyValue));
        try {
            HBaseRow row;
            Result result = hTable.get(get);
            SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
            hBaseRow = row = new HBaseRow((DataSetHeader)header, result);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Failed to execute HBase get operation with " + primaryKeyColumn.getName() + " = " + keyValue, e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{hTable});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{hTable});
        return hBaseRow;
    }

    protected DataSet materializeMainSchemaTable(org.apache.metamodel.schema.Table table, Column[] columns, int maxRows) {
        Scan scan = new Scan();
        for (Column column : columns) {
            if (column.isPrimaryKey()) continue;
            int colonIndex = column.getName().indexOf(58);
            if (colonIndex != -1) {
                String family = column.getName().substring(0, colonIndex);
                scan.addFamily(family.getBytes());
                continue;
            }
            scan.addFamily(column.getName().getBytes());
        }
        if (maxRows > 0) {
            this.setMaxRows(scan, maxRows);
        }
        Table hTable = this.getHTable(table.getName());
        try {
            ResultScanner scanner = hTable.getScanner(scan);
            return new HBaseDataSet(columns, scanner, hTable);
        }
        catch (Exception e) {
            FileHelper.safeClose((Object[])new Object[]{hTable});
            throw new MetaModelException(e);
        }
    }

    private void setMaxRows(Scan scan, int maxRows) {
        try {
            Method method = scan.getClass().getMethod("setMaxResultSize", Long.TYPE);
            method.invoke((Object)scan, maxRows);
            logger.debug("Succesfully set maxRows using Scan.setMaxResultSize({})", (Object)maxRows);
        }
        catch (Exception e) {
            logger.debug("HBase API does not have Scan.setMaxResultSize(long) method, setting maxRows using PageFilter.", (Throwable)e);
            scan.setFilter((Filter)new PageFilter((long)maxRows));
        }
    }
}

