/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.math.BigDecimal;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.metamodel.MetaModelException;

public class ByteUtils {
    public static byte[] toBytes(Object o) {
        if (o != null) {
            return ByteUtils.toBytes(o, o.getClass());
        }
        return null;
    }

    public static byte[] toBytes(Object value, Class<?> klass) {
        if (klass.isAssignableFrom(String.class)) {
            return Bytes.toBytes((String)value.toString());
        }
        if (klass.equals(Integer.TYPE) || klass.isAssignableFrom(Integer.class)) {
            return Bytes.toBytes((int)(value instanceof Integer ? (Integer)value : new Integer(value.toString())));
        }
        if (klass.equals(Long.TYPE) || klass.isAssignableFrom(Long.class)) {
            return Bytes.toBytes((long)(value instanceof Long ? (Long)value : new Long(value.toString())));
        }
        if (klass.equals(Boolean.TYPE) || klass.isAssignableFrom(Boolean.class)) {
            return Bytes.toBytes((boolean)(value instanceof Boolean ? (Boolean)value : new Boolean(value.toString())));
        }
        if (klass.equals(Double.TYPE) || klass.isAssignableFrom(Double.class)) {
            return Bytes.toBytes((double)(value instanceof Double ? (Double)value : new Double(value.toString())));
        }
        if (klass.equals(Float.TYPE) || klass.isAssignableFrom(Float.class)) {
            return Bytes.toBytes((float)(value instanceof Float ? (Float)value : new Float(value.toString())).floatValue());
        }
        if (klass.equals(Short.TYPE) || klass.isAssignableFrom(Short.class)) {
            return Bytes.toBytes((short)(value instanceof Short ? (Short)value : new Short(value.toString())));
        }
        if (klass.equals(BigDecimal.class)) {
            return Bytes.toBytes((BigDecimal)(value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString())));
        }
        throw new MetaModelException("Could not find a suitable Type to assign value for give type " + klass.getName());
    }

    public static Object toObject(byte[] b, Class<?> klass) {
        if (klass.isAssignableFrom(String.class)) {
            return Bytes.toString((byte[])b);
        }
        if (klass.equals(Integer.TYPE) || klass.isAssignableFrom(Integer.class)) {
            return Bytes.toInt((byte[])b);
        }
        if (klass.equals(Long.TYPE) || klass.isAssignableFrom(Long.class)) {
            return Bytes.toLong((byte[])b);
        }
        if (klass.equals(Boolean.TYPE) || klass.isAssignableFrom(Boolean.class)) {
            return Bytes.toBoolean((byte[])b);
        }
        if (klass.equals(Double.TYPE) || klass.isAssignableFrom(Double.class)) {
            return Bytes.toDouble((byte[])b);
        }
        if (klass.equals(Float.TYPE) || klass.isAssignableFrom(Float.class)) {
            return Float.valueOf(Bytes.toFloat((byte[])b));
        }
        if (klass.equals(Short.TYPE) || klass.isAssignableFrom(Short.class)) {
            return Bytes.toShort((byte[])b);
        }
        if (klass.equals(BigDecimal.class)) {
            return Bytes.toBigDecimal((byte[])b);
        }
        throw new MetaModelException("Could Not find a suitable Type for " + klass.getName());
    }
}

