/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.metamodel.hbase.ByteUtils;

public class HBaseFamilyMap
implements Map<Object, Object> {
    private final NavigableMap<byte[], byte[]> _map;

    public HBaseFamilyMap(NavigableMap<byte[], byte[]> map) {
        this._map = map;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(ByteUtils.toBytes(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(ByteUtils.toBytes(value));
    }

    @Override
    public Object get(Object key) {
        return this._map.get(ByteUtils.toBytes(key));
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("HBase row value map is immutable");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("HBase row value map is immutable");
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        throw new UnsupportedOperationException("HBase row value map is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("HBase row value map is immutable");
    }

    @Override
    public Set<Object> keySet() {
        Set<Object> keySet = this._map.keySet();
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        Collection<Object> values = this._map.values();
        return values;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        Set<Map.Entry<Object, Object>> entrySet = this._map.entrySet();
        return entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry entry : this._map.entrySet()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(Arrays.toString((byte[])entry.getKey()));
            sb.append('=');
            sb.append(Arrays.toString((byte[])entry.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }
}

