/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.annotations.InterfaceStability;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.hbase.ByteUtils;
import org.apache.metamodel.hbase.HBaseClient;
import org.apache.metamodel.hbase.HBaseConfiguration;
import org.apache.metamodel.hbase.HBaseDataSet;
import org.apache.metamodel.hbase.HBaseRow;
import org.apache.metamodel.hbase.HBaseTable;
import org.apache.metamodel.hbase.HBaseUpdateCallback;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.SimpleTableDef;

@InterfaceStability.Evolving
public class HBaseDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    public static final String FIELD_ID = "_id";
    private final HBaseConfiguration _configuration;
    private final Connection _connection;

    public HBaseDataContext(HBaseConfiguration configuration) {
        super(false);
        Configuration config = HBaseDataContext.createConfig(configuration);
        this._configuration = configuration;
        this._connection = this.createConnection(config);
    }

    public HBaseDataContext(HBaseConfiguration configuration, Connection connection) {
        super(false);
        this._configuration = configuration;
        this._connection = connection;
    }

    private Connection createConnection(Configuration config) {
        try {
            return ConnectionFactory.createConnection((Configuration)config);
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    private static Configuration createConfig(HBaseConfiguration configuration) {
        Configuration config = org.apache.hadoop.hbase.HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", configuration.getZookeeperHostname());
        config.set("hbase.zookeeper.property.clientPort", Integer.toString(configuration.getZookeeperPort()));
        config.set("hbase.client.retries.number", Integer.toString(configuration.getHBaseClientRetries()));
        config.set("zookeeper.session.timeout", Integer.toString(configuration.getZookeeperSessionTimeout()));
        config.set("zookeeper.recovery.retry", Integer.toString(configuration.getZookeeperRecoveryRetries()));
        return config;
    }

    public Admin getAdmin() {
        try {
            return this._connection.getAdmin();
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    public Connection getConnection() {
        return this._connection;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this._configuration.getSchemaName());
        SimpleTableDef[] tableDefinitions = this._configuration.getTableDefinitions();
        if (tableDefinitions == null) {
            try {
                List tables = this.getAdmin().listTableDescriptors();
                tableDefinitions = new SimpleTableDef[tables.size()];
                for (int i = 0; i < tables.size(); ++i) {
                    SimpleTableDef emptyTableDef;
                    String tableName = ((TableDescriptor)tables.get(i)).getTableName().getNameAsString();
                    tableDefinitions[i] = emptyTableDef = new SimpleTableDef(tableName, new String[0]);
                }
            }
            catch (IOException e) {
                throw new MetaModelException((Exception)e);
            }
        }
        for (SimpleTableDef tableDef : tableDefinitions) {
            schema.addTable((org.apache.metamodel.schema.Table)new HBaseTable(this, tableDef, schema, this._configuration.getDefaultRowKeyType()));
        }
        return schema;
    }

    public HBaseConfiguration getConfiguration() {
        return this._configuration;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._configuration.getSchemaName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Number executeCountQuery(org.apache.metamodel.schema.Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (whereItems != null && !whereItems.isEmpty()) {
            return null;
        }
        long result = 0L;
        Table hTable = this.getHTable(table.getName());
        try {
            try (ResultScanner scanner = hTable.getScanner(new Scan());){
                while (scanner.next() != null) {
                    ++result;
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    protected Table getHTable(String name) {
        try {
            TableName tableName = TableName.valueOf((String)name);
            Table hTable = this._connection.getTable(tableName);
            return hTable;
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    protected Row executePrimaryKeyLookupQuery(org.apache.metamodel.schema.Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        HBaseRow hBaseRow;
        Table hTable = this.getHTable(table.getName());
        Get get = new Get(ByteUtils.toBytes(keyValue));
        try {
            HBaseRow row;
            Result result = hTable.get(get);
            SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
            hBaseRow = row = new HBaseRow((DataSetHeader)header, result);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Failed to execute HBase get operation with " + primaryKeyColumn.getName() + " = " + keyValue, e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{hTable});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{hTable});
        return hBaseRow;
    }

    protected DataSet materializeMainSchemaTable(org.apache.metamodel.schema.Table table, List<Column> columns, int maxRows) {
        Scan scan = new Scan();
        for (Column column : columns) {
            if (column.isPrimaryKey()) continue;
            int colonIndex = column.getName().indexOf(58);
            if (colonIndex != -1) {
                String family = column.getName().substring(0, colonIndex);
                scan.addFamily(family.getBytes());
                continue;
            }
            scan.addFamily(column.getName().getBytes());
        }
        if (maxRows > 0) {
            this.setMaxRows(scan, maxRows);
        }
        Table hTable = this.getHTable(table.getName());
        try {
            ResultScanner scanner = hTable.getScanner(scan);
            return new HBaseDataSet(columns, scanner, hTable);
        }
        catch (Exception e) {
            FileHelper.safeClose((Object[])new Object[]{hTable});
            throw new MetaModelException(e);
        }
    }

    private void setMaxRows(Scan scan, int maxRows) {
        scan.setFilter((Filter)new PageFilter((long)maxRows));
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        HBaseUpdateCallback callback = new HBaseUpdateCallback(this);
        update.run((UpdateCallback)callback);
        return callback.getUpdateSummary();
    }

    HBaseClient getHBaseClient() {
        return new HBaseClient(this.getConnection());
    }
}

