/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.hbase.HBaseColumn;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.hbase.HBaseTable;
import org.apache.metamodel.hbase.HBaseUpdateCallback;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

class HBaseRowInsertionBuilder
implements RowInsertionBuilder {
    private List<HBaseColumn> _columns = new ArrayList<HBaseColumn>();
    private List<Object> _values = new ArrayList<Object>();
    private int _indexOfIdColumn = -1;
    private final HBaseUpdateCallback _updateCallback;
    private final HBaseTable _table;

    public HBaseRowInsertionBuilder(HBaseUpdateCallback updateCallback, HBaseTable table) {
        this._updateCallback = updateCallback;
        this._table = table;
        this.checkTable(table);
    }

    private void checkTable(HBaseTable tableGettingInserts) {
        HBaseTable tableInSchema = (HBaseTable)this._updateCallback.getDataContext().getDefaultSchema().getTableByName(tableGettingInserts.getName());
        if (tableInSchema == null) {
            throw new MetaModelException("Trying to insert data into table: " + tableGettingInserts.getName() + ", which doesn't exist yet");
        }
        this.checkColumnFamilies(tableInSchema, tableGettingInserts.getColumnFamilies());
    }

    public void checkColumnFamilies(HBaseTable table, Set<String> columnFamilyNamesOfCheckedTable) {
        Set<String> columnFamilyNamesOfExistingTable = table.getColumnFamilies();
        for (String columnNameOfCheckedTable : columnFamilyNamesOfCheckedTable) {
            boolean matchingColumnFound = false;
            Iterator<String> columnFamilies = columnFamilyNamesOfExistingTable.iterator();
            while (!matchingColumnFound && columnFamilies.hasNext()) {
                if (!columnNameOfCheckedTable.equals(columnFamilies.next())) continue;
                matchingColumnFound = true;
            }
            if (matchingColumnFound) continue;
            throw new MetaModelException(String.format("ColumnFamily: %s doesn't exist in the schema of the table", columnNameOfCheckedTable));
        }
    }

    private static Set<String> getColumnFamilies(HBaseColumn[] columns) {
        return Arrays.stream(columns).map(HBaseColumn::getColumnFamily).distinct().collect(Collectors.toSet());
    }

    public synchronized void execute() {
        if (this._indexOfIdColumn == -1) {
            throw new MetaModelException("The ID-Column was not found");
        }
        this.checkColumnFamilies(this.getTable(), HBaseRowInsertionBuilder.getColumnFamilies(this.getColumns()));
        ((HBaseDataContext)this._updateCallback.getDataContext()).getHBaseClient().insertRow(this.getTable().getName(), this.getColumns(), this.getValues(), this._indexOfIdColumn);
    }

    private HBaseColumn[] getColumns() {
        return this._columns.toArray(new HBaseColumn[this._columns.size()]);
    }

    private Object[] getValues() {
        return this._values.toArray(new Object[this._values.size()]);
    }

    public RowInsertionBuilder value(Column column, Object value, Style style) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null.");
        }
        HBaseColumn hbaseColumn = this.getHbaseColumn(column);
        for (int i = 0; i < this._columns.size(); ++i) {
            if (!this._columns.get(i).equals((Object)hbaseColumn)) continue;
            this._values.set(i, value);
            return this;
        }
        if (hbaseColumn.isPrimaryKey()) {
            this._indexOfIdColumn = this._columns.size();
        }
        this._columns.add(hbaseColumn);
        this._values.add(value);
        return this;
    }

    private HBaseColumn getHbaseColumn(Column column) {
        if (column instanceof HBaseColumn) {
            return (HBaseColumn)column;
        }
        String columnName = column.getName();
        String[] columnNameParts = columnName.split(":");
        if (columnNameParts.length == 1) {
            return new HBaseColumn(columnNameParts[0], (Table)this.getTable());
        }
        if (columnNameParts.length == 2) {
            return new HBaseColumn(columnNameParts[0], columnNameParts[1], (Table)this.getTable());
        }
        throw new MetaModelException("Can't determine column family for column \"" + columnName + "\".");
    }

    public boolean isSet(Column column) {
        for (int i = 0; i < this._columns.size(); ++i) {
            if (!this._columns.get(i).equals(column)) continue;
            return this._values.get(i) != null;
        }
        return false;
    }

    public RowInsertionBuilder value(int columnIndex, Object value) {
        return this.value(columnIndex, value, null);
    }

    public RowInsertionBuilder value(int columnIndex, Object value, Style style) {
        this._values.set(columnIndex, value);
        return this;
    }

    public RowInsertionBuilder value(String columnName, Object value) {
        return this.value(columnName, value, null);
    }

    public RowInsertionBuilder value(Column column, Object value) {
        return this.value(column, value, null);
    }

    public RowInsertionBuilder value(String columnName, Object value, Style style) {
        for (Column column : this._columns) {
            if (!column.getName().equals(columnName)) continue;
            return this.value(column, value, null);
        }
        throw new IllegalArgumentException("No such column in table: " + columnName + ", available columns are: " + this._columns);
    }

    public Row toRow() {
        return new DefaultRow((DataSetHeader)new SimpleDataSetHeader(this._columns.stream().map(SelectItem::new).collect(Collectors.toList())), this.getValues());
    }

    public HBaseTable getTable() {
        return this._table;
    }

    public RowInsertionBuilder like(Row row) {
        List selectItems = row.getSelectItems();
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = (SelectItem)selectItems.get(i);
            Column column = selectItem.getColumn();
            if (column == null) continue;
            if (this._table == column.getTable()) {
                this.value(column, row.getValue(i));
                continue;
            }
            this.value(column.getName(), row.getValue(i));
        }
        return this;
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this._table.getQualifiedLabel());
        sb.append("(");
        sb.append(this._columns.stream().map(Column::getName).collect(Collectors.joining(",")));
        sb.append(") VALUES (");
        sb.append(this._values.stream().map(value -> {
            if (value == null) {
                return "NULL";
            }
            if (value instanceof String) {
                return "\"" + value + "\"";
            }
            return value.toString();
        }).collect(Collectors.joining(",")));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

