/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.Map;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.hbase.HBaseConfiguration;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.util.SimpleTableDef;

public class HbaseDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "hbase";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        Map map = properties.toMap();
        String schemaName = this.getString(map.get("schema"), this.getString(properties.getDatabaseName(), "HBase"));
        String zookeeperHostname = this.getString(map.get("zookeeper-hostname"), "127.0.0.1");
        int zookeeperPort = this.getInt(map.get("zookeeper-port"), 2181);
        SimpleTableDef[] tableDefinitions = properties.getTableDefs();
        Object configuredDefaultRowKeyType = map.get("default-row-key-type");
        ColumnType defaultRowKeyType = configuredDefaultRowKeyType == null ? HBaseConfiguration.DEFAULT_ROW_KEY_TYPE : (configuredDefaultRowKeyType instanceof ColumnType ? (ColumnType)configuredDefaultRowKeyType : (configuredDefaultRowKeyType instanceof String && !((String)configuredDefaultRowKeyType).isEmpty() ? ColumnTypeImpl.valueOf((String)((String)configuredDefaultRowKeyType)) : HBaseConfiguration.DEFAULT_ROW_KEY_TYPE));
        int hbaseClientRetries = this.getInt(map.get("hbase-client-retries"), 1);
        int zookeeperSessionTimeout = this.getInt(map.get("zookeeper-session-timeout"), 5000);
        int zookeeperRecoveryRetries = this.getInt(map.get("zookeeper-recovery-retries"), 1);
        HBaseConfiguration configuration = new HBaseConfiguration(schemaName, zookeeperHostname, zookeeperPort, tableDefinitions, defaultRowKeyType, hbaseClientRetries, zookeeperSessionTimeout, zookeeperRecoveryRetries);
        return new HBaseDataContext(configuration);
    }
}

