/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.jdbc.dialects.LimitOffsetQueryRewriter;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

public class PostgresqlQueryRewriter
extends LimitOffsetQueryRewriter
implements IQueryRewriter {
    public PostgresqlQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public ColumnType getColumnType(int jdbcType, String nativeType, Integer columnSize) {
        if ("bool".equals(nativeType)) {
            return ColumnType.BOOLEAN;
        }
        return super.getColumnType(jdbcType, nativeType, columnSize);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType) {
        if (columnType == ColumnType.BLOB) {
            return "bytea";
        }
        return super.rewriteColumnType(columnType);
    }

    @Override
    protected String rewriteFromItem(Query query, FromItem item) {
        String schemaName;
        Schema schema;
        String result = super.rewriteFromItem(query, item);
        Table table = item.getTable();
        if (table != null && (schema = table.getSchema()) != null && (schemaName = schema.getName()) != null) {
            result = result.replaceFirst(schemaName, '\"' + schema.getName() + '\"');
        }
        return result;
    }
}

