/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.jdbc.JdbcCreateTableBuilder;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.JdbcDeleteBuilder;
import org.apache.metamodel.jdbc.JdbcDropTableBuilder;
import org.apache.metamodel.jdbc.JdbcInsertBuilder;
import org.apache.metamodel.jdbc.JdbcUpdateBuilder;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.SqlKeywords;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.RowUpdationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JdbcUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUpdateCallback.class);
    private final JdbcDataContext _dataContext;
    private Connection _connection;
    private String _preparedStatementSql;
    private PreparedStatement _preparedStatement;

    public JdbcUpdateCallback(JdbcDataContext dataContext) {
        super((DataContext)dataContext);
        this._dataContext = dataContext;
    }

    protected abstract void closePreparedStatement(PreparedStatement var1);

    protected abstract void executePreparedStatement(PreparedStatement var1) throws SQLException;

    public void executePreparedStatement(PreparedStatement preparedStatement, boolean reusedStatement) throws SQLException {
        this.executePreparedStatement(preparedStatement);
        if (!reusedStatement) {
            this.closePreparedStatement(preparedStatement);
        }
    }

    protected final Connection getConnection() {
        if (this._connection == null) {
            this._connection = this.getDataContext().getConnection();
            if (this._dataContext.getQueryRewriter().isTransactional()) {
                try {
                    this._connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw JdbcUtils.wrapException(e, "disable auto-commit");
                }
            }
        }
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean success) {
        block8: {
            if (this._connection != null) {
                if (success && this._preparedStatement != null) {
                    this.closePreparedStatement(this._preparedStatement);
                }
                if (this._dataContext.getQueryRewriter().isTransactional()) {
                    try {
                        this.commitOrRollback(success);
                        if (!this._dataContext.isDefaultAutoCommit()) break block8;
                        try {
                            this.getConnection().setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            throw JdbcUtils.wrapException(e, "enable auto-commit");
                        }
                    }
                    finally {
                        this.getDataContext().close(this._connection, null, null);
                    }
                }
            }
        }
    }

    private void commitOrRollback(boolean success) {
        if (success) {
            try {
                this.getConnection().commit();
            }
            catch (SQLException e) {
                throw JdbcUtils.wrapException(e, "commit transaction");
            }
        }
        try {
            this.getConnection().rollback();
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "rollback transaction");
        }
    }

    public final TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new JdbcCreateTableBuilder(this, schema, name);
    }

    public final RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        return new JdbcInsertBuilder(this, table, this._dataContext.getQueryRewriter());
    }

    public final JdbcDataContext getDataContext() {
        return this._dataContext;
    }

    protected String quoteIfNescesary(String identifier) {
        if (identifier == null) {
            return null;
        }
        String quote = this._dataContext.getIdentifierQuoteString();
        if (quote == null) {
            return identifier;
        }
        boolean quotes = false;
        if (identifier.indexOf(32) != -1 || identifier.indexOf(45) != -1) {
            quotes = true;
        } else if (SqlKeywords.isKeyword(identifier)) {
            quotes = true;
        }
        if (quotes) {
            identifier = quote + identifier + quote;
        }
        return identifier;
    }

    public final PreparedStatement getPreparedStatement(String sql, boolean reuseStatement) {
        PreparedStatement preparedStatement;
        if (reuseStatement) {
            if (sql.equals(this._preparedStatementSql)) {
                preparedStatement = this._preparedStatement;
            } else {
                if (this._preparedStatement != null) {
                    try {
                        this.closePreparedStatement(this._preparedStatement);
                    }
                    catch (RuntimeException e) {
                        logger.error("Exception occurred while closing prepared statement: " + this._preparedStatementSql);
                        throw e;
                    }
                }
                this._preparedStatement = preparedStatement = this.createPreparedStatement(sql);
                this._preparedStatementSql = sql;
            }
        } else {
            preparedStatement = this.createPreparedStatement(sql);
        }
        return preparedStatement;
    }

    private final PreparedStatement createPreparedStatement(String sql) {
        try {
            return this.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "create prepared statement for: " + sql);
        }
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JdbcDeleteBuilder(this, table, this._dataContext.getQueryRewriter());
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JdbcDropTableBuilder(this, table, this._dataContext.getQueryRewriter());
    }

    public boolean isUpdateSupported() {
        return true;
    }

    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JdbcUpdateBuilder(this, table, this._dataContext.getQueryRewriter());
    }
}

