/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.QueryParameter;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FormatHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    public static MetaModelException wrapException(SQLException e, String actionDescription) throws MetaModelException {
        String message = e.getMessage();
        message = message == null || message.isEmpty() ? "Could not " + actionDescription : "Could not " + actionDescription + ": " + message;
        logger.error(message, (Throwable)e);
        logger.error("Error code={}, SQL state={}", (Object)e.getErrorCode(), (Object)e.getSQLState());
        SQLException nextException = e.getNextException();
        if (nextException != null) {
            logger.error("Next SQL exception: " + nextException.getMessage(), (Throwable)nextException);
        }
        return new MetaModelException(message, (Exception)e);
    }

    public static void setStatementValue(PreparedStatement st, int valueIndex, Column column, Object value) throws SQLException {
        ColumnType type;
        ColumnType columnType = type = column == null ? null : column.getType();
        if (type == null || type == ColumnType.OTHER) {
            st.setObject(valueIndex, value);
            return;
        }
        if (value == null && type != null) {
            try {
                int jdbcType = type.getJdbcType();
                st.setNull(valueIndex, jdbcType);
                return;
            }
            catch (Exception e) {
                logger.warn("Exception occurred while calling setNull(...) for value index " + valueIndex + ". Attempting value-based setter method instead.", (Throwable)e);
            }
        }
        if (type == ColumnType.VARCHAR && value instanceof java.util.Date) {
            String nativeType = column.getNativeType();
            java.util.Date date = (java.util.Date)value;
            if ("DATE".equalsIgnoreCase(nativeType)) {
                value = FormatHelper.formatSqlTime((ColumnType)ColumnType.DATE, (java.util.Date)date, (boolean)false);
            } else if ("TIME".equalsIgnoreCase(nativeType)) {
                value = FormatHelper.formatSqlTime((ColumnType)ColumnType.TIME, (java.util.Date)date, (boolean)false);
            } else if ("TIMESTAMP".equalsIgnoreCase(nativeType) || "DATETIME".equalsIgnoreCase(nativeType)) {
                value = FormatHelper.formatSqlTime((ColumnType)ColumnType.TIMESTAMP, (java.util.Date)date, (boolean)false);
            }
        }
        if (type != null && type.isTimeBased() && value instanceof String) {
            value = FormatHelper.parseSqlTime((ColumnType)type, (String)((String)value));
        }
        try {
            InputStream inputStream;
            if (type == ColumnType.DATE && value instanceof java.util.Date) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((java.util.Date)value);
                st.setDate(valueIndex, new Date(cal.getTimeInMillis()), cal);
            } else if (type == ColumnType.TIME && value instanceof java.util.Date) {
                Time time = JdbcUtils.toTime((java.util.Date)value);
                st.setTime(valueIndex, time);
            } else if (type == ColumnType.TIMESTAMP && value instanceof java.util.Date) {
                Timestamp ts = JdbcUtils.toTimestamp((java.util.Date)value);
                st.setTimestamp(valueIndex, ts);
            } else if (type == ColumnType.CLOB || type == ColumnType.NCLOB) {
                if (value instanceof InputStream) {
                    inputStream = (InputStream)value;
                    st.setAsciiStream(valueIndex, inputStream);
                } else if (value instanceof Reader) {
                    Reader reader = (Reader)value;
                    st.setCharacterStream(valueIndex, reader);
                } else if (value instanceof NClob) {
                    NClob nclob = (NClob)value;
                    st.setNClob(valueIndex, nclob);
                } else if (value instanceof Clob) {
                    Clob clob = (Clob)value;
                    st.setClob(valueIndex, clob);
                } else if (value instanceof String) {
                    st.setString(valueIndex, (String)value);
                } else {
                    st.setObject(valueIndex, value);
                }
            } else if (type == ColumnType.BLOB || type == ColumnType.BINARY) {
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    st.setBytes(valueIndex, bytes);
                } else if (value instanceof InputStream) {
                    inputStream = (InputStream)value;
                    st.setBinaryStream(valueIndex, inputStream);
                } else if (value instanceof Blob) {
                    Blob blob = (Blob)value;
                    st.setBlob(valueIndex, blob);
                } else {
                    st.setObject(valueIndex, value);
                }
            } else if (type.isLiteral()) {
                String str;
                if (value instanceof Reader) {
                    Reader reader = (Reader)value;
                    str = FileHelper.readAsString((Reader)reader);
                } else {
                    str = value.toString();
                }
                st.setString(valueIndex, str);
            } else {
                st.setObject(valueIndex, value);
            }
        }
        catch (SQLException e) {
            logger.error("Failed to set parameter {} to value: {}", (Object)valueIndex, value);
            throw e;
        }
    }

    private static Time toTime(java.util.Date value) {
        if (value instanceof Time) {
            return (Time)value;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        return new Time(cal.getTimeInMillis());
    }

    private static Timestamp toTimestamp(java.util.Date value) {
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static String getValueAsSql(Column column, Object value, IQueryRewriter queryRewriter) {
        if (value == null) {
            return "NULL";
        }
        ColumnType columnType = column.getType();
        if (columnType.isLiteral() && value instanceof String) {
            value = queryRewriter.escapeQuotes((String)value);
        }
        String formatSqlValue = FormatHelper.formatSqlValue((ColumnType)columnType, (Object)value);
        return formatSqlValue;
    }

    public static String createWhereClause(List<FilterItem> whereItems, IQueryRewriter queryRewriter, boolean inlineValues) {
        if (whereItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE ");
        boolean firstValue = true;
        for (FilterItem whereItem : whereItems) {
            if (firstValue) {
                firstValue = false;
            } else {
                sb.append(" AND ");
            }
            if (!inlineValues && JdbcUtils.isPreparedParameterCandidate(whereItem)) {
                whereItem = new FilterItem(whereItem.getSelectItem(), whereItem.getOperator(), (Object)new QueryParameter());
            }
            String whereItemLabel = queryRewriter.rewriteFilterItem(whereItem);
            sb.append(whereItemLabel);
        }
        return sb.toString();
    }

    public static boolean isPreparedParameterCandidate(FilterItem whereItem) {
        return !whereItem.isCompoundFilter() && !OperatorType.IN.equals(whereItem.getOperator()) && whereItem.getOperand() != null;
    }

    public static String[] getTableTypesAsStrings(TableType[] tableTypes) {
        String[] types = new String[tableTypes.length];
        for (int i = 0; i < types.length; ++i) {
            if (tableTypes[i] == TableType.OTHER) {
                types = null;
                break;
            }
            types[i] = tableTypes[i].toString();
        }
        return types;
    }
}

