/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectClause;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;

public class HsqldbQueryRewriter
extends DefaultQueryRewriter {
    public HsqldbQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.BIT) {
            return "BOOLEAN";
        }
        if (columnType == ColumnType.BLOB) {
            return "LONGVARBINARY";
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public boolean isFirstRowSupported() {
        return true;
    }

    @Override
    public boolean isMaxRowsSupported() {
        return true;
    }

    @Override
    protected String rewriteSelectClause(Query query, SelectClause selectClause) {
        String result = super.rewriteSelectClause(query, selectClause);
        Integer firstRow = query.getFirstRow();
        Integer maxRows = query.getMaxRows();
        if (maxRows != null || firstRow != null) {
            if (maxRows == null) {
                maxRows = Integer.MAX_VALUE;
            }
            if (firstRow == null || firstRow <= 0) {
                result = "SELECT TOP " + maxRows + " " + result.substring(7);
            } else {
                int offset = firstRow - 1;
                result = "SELECT LIMIT " + offset + " " + maxRows + " " + result.substring(7);
            }
        }
        return result;
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        SelectItem selectItem;
        Column column;
        if (!item.isCompoundFilter() && (column = (selectItem = item.getSelectItem()).getColumn()) != null && column.getType() == ColumnType.TIMESTAMP) {
            String result = super.rewriteFilterItem(item);
            int indexOfTimestamp = result.lastIndexOf("TIMESTAMP");
            if (indexOfTimestamp != -1) {
                result = result.substring(0, indexOfTimestamp) + result.substring(indexOfTimestamp + "TIMESTAMP".length());
            }
            return result;
        }
        return super.rewriteFilterItem(item);
    }
}

