/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import java.util.Date;
import java.util.List;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.FormatHelper;
import org.apache.metamodel.util.TimeComparator;

public class DB2QueryRewriter
extends DefaultQueryRewriter {
    public DB2QueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public String escapeQuotes(String filterItemOperand) {
        return filterItemOperand.replaceAll("\\'", "\\\\'");
    }

    @Override
    public boolean isSchemaIncludedInColumnPaths() {
        return true;
    }

    @Override
    public boolean isMaxRowsSupported() {
        return true;
    }

    @Override
    public boolean isFirstRowSupported(Query query) {
        return true;
    }

    @Override
    public String rewriteQuery(Query query) {
        Integer firstRow = query.getFirstRow();
        Integer maxRows = query.getMaxRows();
        if (maxRows == null && (firstRow == null || firstRow == 1)) {
            return super.rewriteQuery(query);
        }
        if ((firstRow == null || firstRow == 1) && maxRows != null && maxRows > 0) {
            return super.rewriteQuery(query) + " FETCH FIRST " + maxRows + " ROWS ONLY";
        }
        Query innerQuery = query.clone();
        innerQuery.setFirstRow(null);
        innerQuery.setMaxRows(null);
        Query outerQuery = new Query();
        FromItem subQuerySelectItem = new FromItem(innerQuery).setAlias("metamodel_subquery");
        outerQuery.from(new FromItem[]{subQuerySelectItem});
        List innerSelectItems = innerQuery.getSelectClause().getItems();
        for (SelectItem selectItem : innerSelectItems) {
            outerQuery.select(new SelectItem[]{new SelectItem(selectItem, subQuerySelectItem)});
        }
        String rewrittenOrderByClause = this.rewriteOrderByClause(innerQuery, innerQuery.getOrderByClause());
        String rowOver = "ROW_NUMBER() OVER(" + rewrittenOrderByClause + ")";
        innerQuery.select(new SelectItem[]{new SelectItem(rowOver, "metamodel_row_number")});
        innerQuery.getOrderByClause().removeItems();
        String baseQueryString = this.rewriteQuery(outerQuery);
        if (maxRows == null) {
            return baseQueryString + " WHERE metamodel_row_number > " + (firstRow - 1);
        }
        return baseQueryString + " WHERE metamodel_row_number BETWEEN " + firstRow + " AND " + (firstRow - 1 + maxRows);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.BOOLEAN || columnType == ColumnType.BIT) {
            return "SMALLINT";
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        ColumnType columnType;
        SelectItem selectItem = item.getSelectItem();
        Object itemOperand = item.getOperand();
        OperatorType operator = item.getOperator();
        if (null != selectItem && itemOperand != null && (columnType = selectItem.getExpectedColumnType()) != null && columnType.isTimeBased()) {
            StringBuilder sb = new StringBuilder();
            sb.append(selectItem.getSameQueryAlias(true));
            Object operand = FilterItem.appendOperator((StringBuilder)sb, (Object)itemOperand, (OperatorType)operator);
            if (operand instanceof SelectItem) {
                String selectItemString = ((SelectItem)operand).getSameQueryAlias(true);
                sb.append(selectItemString);
            } else {
                Date date = TimeComparator.toDate((Object)itemOperand);
                if (date == null) {
                    throw new IllegalStateException("Could not convert " + itemOperand + " to date");
                }
                String sqlValue = FormatHelper.formatSqlTime((ColumnType)columnType, (Date)date, (boolean)true, (String)"('", (String)"')");
                sb.append(sqlValue);
            }
            return sb.toString();
        }
        return super.rewriteFilterItem(item);
    }
}

