/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import java.text.DateFormat;
import java.util.Date;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.OffsetFetchQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectClause;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.DateUtils;

public class SQLServerQueryRewriter
extends OffsetFetchQueryRewriter {
    public static final int FIRST_FETCH_SUPPORTING_VERSION = 11;

    public SQLServerQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext, 11, true);
    }

    @Override
    public boolean isMaxRowsSupported() {
        return true;
    }

    @Override
    public boolean isSchemaIncludedInColumnPaths() {
        return true;
    }

    @Override
    protected String rewriteSelectClause(Query query, SelectClause selectClause) {
        String result = super.rewriteSelectClause(query, selectClause);
        Integer maxRows = query.getMaxRows();
        if (maxRows != null) {
            result = query.getSelectClause().isDistinct() ? "SELECT DISTINCT TOP " + maxRows + " " + result.substring("SELECT DISTINCT ".length()) : "SELECT TOP " + maxRows + " " + result.substring("SELECT ".length());
        }
        return result;
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.DOUBLE) {
            return "FLOAT";
        }
        if (columnType == ColumnType.BOOLEAN) {
            return "BIT";
        }
        if (columnType.isLiteral() && columnSize == null) {
            return this.rewriteColumnTypeInternal(columnType.getName(), "MAX");
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        String nativeType;
        if (item.isCompoundFilter()) {
            return super.rewriteFilterItem(item);
        }
        SelectItem selectItem = item.getSelectItem();
        Object operand = item.getOperand();
        OperatorType operator = item.getOperator();
        if (selectItem == null || operand == null || operator == null) {
            return super.rewriteFilterItem(item);
        }
        Column column = selectItem.getColumn();
        if (column == null) {
            return super.rewriteFilterItem(item);
        }
        if (operand instanceof Date && ("TIMESTAMP".equalsIgnoreCase(nativeType = column.getNativeType()) || "DATETIME".equalsIgnoreCase(nativeType))) {
            StringBuilder sb = new StringBuilder();
            sb.append(selectItem.getSameQueryAlias(true));
            FilterItem.appendOperator((StringBuilder)sb, (Object)operand, (OperatorType)operator);
            Date date = (Date)operand;
            DateFormat format = DateUtils.createDateFormat((String)"yyyyMMdd HH:mm:ss");
            String dateTimeValue = "CAST('" + format.format(date) + "' AS DATETIME)";
            sb.append(dateTimeValue);
            return sb.toString();
        }
        return super.rewriteFilterItem(item);
    }
}

