/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.query.CompiledQuery;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.builder.InitFromBuilder;
import org.apache.metamodel.query.builder.InitFromBuilderImpl;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

final class JdbcUpdateCallbackDataContext
implements DataContext {
    private final JdbcDataContext delegate;
    private final Connection connection;

    public JdbcUpdateCallbackDataContext(JdbcDataContext delegate, Connection connection) {
        this.delegate = delegate;
        this.connection = connection;
    }

    public DataSet executeQuery(Query query) throws MetaModelException {
        return this.delegate.executeQuery(this.connection, query, false);
    }

    public InitFromBuilder query() {
        return new InitFromBuilderImpl((DataContext)this);
    }

    public DataContext refreshSchemas() {
        this.delegate.refreshSchemas();
        return this;
    }

    public DataSet executeQuery(String queryString) throws MetaModelException {
        Query query = this.parseQuery(queryString);
        return this.executeQuery(query);
    }

    public DataSet executeQuery(CompiledQuery compiledQuery, Object ... values) {
        return this.delegate.executeQuery(compiledQuery, values);
    }

    public List<Schema> getSchemas() throws MetaModelException {
        return this.delegate.getSchemas();
    }

    public List<String> getSchemaNames() throws MetaModelException {
        return this.delegate.getSchemaNames();
    }

    public Schema getDefaultSchema() throws MetaModelException {
        return this.delegate.getDefaultSchema();
    }

    public Schema getSchemaByName(String name) throws MetaModelException {
        return this.delegate.getSchemaByName(name);
    }

    public Query parseQuery(String queryString) throws MetaModelException {
        return this.delegate.parseQuery(queryString);
    }

    public CompiledQuery compileQuery(Query query) throws MetaModelException {
        return this.delegate.compileQuery(query);
    }

    public Column getColumnByQualifiedLabel(String columnName) {
        return this.delegate.getColumnByQualifiedLabel(columnName);
    }

    public Table getTableByQualifiedLabel(String tableName) {
        return this.delegate.getTableByQualifiedLabel(tableName);
    }
}

