/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateSummaryBuilder;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.jdbc.JdbcCreateTableBuilder;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.JdbcDeleteBuilder;
import org.apache.metamodel.jdbc.JdbcDropTableBuilder;
import org.apache.metamodel.jdbc.JdbcInsertBuilder;
import org.apache.metamodel.jdbc.JdbcUpdateBuilder;
import org.apache.metamodel.jdbc.JdbcUpdateCallbackDataContext;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.SqlKeywords;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.RowUpdationBuilder;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JdbcUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUpdateCallback.class);
    private Connection _connection;
    private String _preparedStatementSql;
    private PreparedStatement _preparedStatement;
    private final UpdateSummaryBuilder _updateSummaryBuilder = new UpdateSummaryBuilder();

    public JdbcUpdateCallback(JdbcDataContext dataContext) {
        super((DataContext)dataContext);
    }

    protected final UpdateSummaryBuilder getUpdateSummaryBuilder() {
        return this._updateSummaryBuilder;
    }

    protected abstract boolean isGeneratedKeysCollectionEnabled();

    protected abstract void closePreparedStatement(PreparedStatement var1);

    protected abstract int executePreparedStatement(PreparedStatement var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executePreparedStatement(PreparedStatement preparedStatement, boolean reusedStatement, boolean collectGeneratedKeys) throws SQLException {
        int result = this.executePreparedStatement(preparedStatement);
        if (collectGeneratedKeys && this.isGeneratedKeysCollectionEnabled()) {
            try {
                ResultSet generatedKeysResultSet = preparedStatement.getGeneratedKeys();
                try {
                    while (generatedKeysResultSet.next()) {
                        Object key = generatedKeysResultSet.getObject(1);
                        this.getUpdateSummaryBuilder().addGeneratedKey(key);
                    }
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{generatedKeysResultSet});
                    throw throwable;
                }
                FileHelper.safeClose((Object[])new Object[]{generatedKeysResultSet});
            }
            catch (SQLFeatureNotSupportedException e) {
                logger.debug("Getting generated keys from JDBC statement is not supported by driver: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (RuntimeException | SQLException e) {
                logger.warn("Failed to get generated keys from JDBC statement: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (!reusedStatement) {
            this.closePreparedStatement(preparedStatement);
        }
        return result;
    }

    protected final Connection getConnection() {
        if (this._connection == null) {
            this._connection = this.getJdbcDataContext().getConnection();
            if (this.getJdbcDataContext().getQueryRewriter().isTransactional()) {
                try {
                    this._connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw JdbcUtils.wrapException(e, "disable auto-commit", JdbcUtils.JdbcActionType.OTHER);
                }
            }
        }
        return this._connection;
    }

    public final void close(boolean success) {
        block8: {
            if (this._connection != null) {
                if (success && this._preparedStatement != null) {
                    this.closePreparedStatement(this._preparedStatement);
                }
                if (this.getJdbcDataContext().getQueryRewriter().isTransactional()) {
                    try {
                        this.commitOrRollback(success);
                        if (!this.getJdbcDataContext().isDefaultAutoCommit()) break block8;
                        try {
                            this.getConnection().setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            throw JdbcUtils.wrapException(e, "enable auto-commit", JdbcUtils.JdbcActionType.OTHER);
                        }
                    }
                    finally {
                        this.getJdbcDataContext().close(this._connection);
                    }
                }
            }
        }
    }

    private void commitOrRollback(boolean success) {
        if (success) {
            try {
                this.getConnection().commit();
            }
            catch (SQLException e) {
                throw JdbcUtils.wrapException(e, "commit transaction", JdbcUtils.JdbcActionType.COMMIT_ROLLBACK);
            }
        }
        try {
            this.getConnection().rollback();
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "rollback transaction", JdbcUtils.JdbcActionType.COMMIT_ROLLBACK);
        }
    }

    public final TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new JdbcCreateTableBuilder(this, schema, name);
    }

    public final RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        return new JdbcInsertBuilder(this, table, this.getJdbcDataContext().getQueryRewriter());
    }

    protected final JdbcDataContext getJdbcDataContext() {
        return (JdbcDataContext)super.getDataContext();
    }

    public final DataContext getDataContext() {
        Connection connection = this.getConnection();
        return new JdbcUpdateCallbackDataContext(this.getJdbcDataContext(), connection);
    }

    protected String quoteIfNescesary(String identifier) {
        if (identifier == null) {
            return null;
        }
        String quote = this.getJdbcDataContext().getIdentifierQuoteString();
        if (quote == null) {
            return identifier;
        }
        boolean quotes = false;
        if (identifier.indexOf(32) != -1 || identifier.indexOf(45) != -1) {
            quotes = true;
        } else if (SqlKeywords.isKeyword(identifier)) {
            quotes = true;
        }
        if (quotes) {
            identifier = quote + identifier + quote;
        }
        return identifier;
    }

    public final PreparedStatement getPreparedStatement(String sql, boolean reuseStatement, boolean returnGeneratedKeys) {
        PreparedStatement preparedStatement;
        if (reuseStatement) {
            if (sql.equals(this._preparedStatementSql)) {
                preparedStatement = this._preparedStatement;
            } else {
                if (this._preparedStatement != null) {
                    try {
                        this.closePreparedStatement(this._preparedStatement);
                    }
                    catch (RuntimeException e) {
                        logger.error("Exception occurred while closing prepared statement: " + this._preparedStatementSql);
                        throw e;
                    }
                }
                this._preparedStatement = preparedStatement = this.createPreparedStatement(sql, returnGeneratedKeys);
                this._preparedStatementSql = sql;
            }
        } else {
            preparedStatement = this.createPreparedStatement(sql, returnGeneratedKeys);
        }
        return preparedStatement;
    }

    private final PreparedStatement createPreparedStatement(String sql, boolean returnGeneratedKeys) {
        try {
            if (returnGeneratedKeys && this.isGeneratedKeysCollectionEnabled()) {
                return this.getConnection().prepareStatement(sql, 1);
            }
            return this.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            if (returnGeneratedKeys) {
                return this.createPreparedStatement(sql, false);
            }
            throw JdbcUtils.wrapException(e, "create prepared statement for: " + sql, JdbcUtils.JdbcActionType.OTHER);
        }
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public final RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JdbcDeleteBuilder(this, table, this.getJdbcDataContext().getQueryRewriter());
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JdbcDropTableBuilder(this, table, this.getJdbcDataContext().getQueryRewriter());
    }

    public boolean isUpdateSupported() {
        return true;
    }

    public final RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JdbcUpdateBuilder(this, table, this.getJdbcDataContext().getQueryRewriter());
    }

    public void executeInsert(PreparedStatement st, boolean reuseStatement) throws SQLException {
        this.executePreparedStatement(st, reuseStatement, true);
        this._updateSummaryBuilder.addInsert();
    }

    public void executeUpdate(PreparedStatement st, boolean reuseStatement) throws SQLException {
        int updates = this.executePreparedStatement(st, reuseStatement, false);
        this._updateSummaryBuilder.addUpdates(updates);
    }

    public void executeDelete(PreparedStatement st, boolean reuseStatement) throws SQLException {
        int deletes = this.executePreparedStatement(st, reuseStatement, false);
        this._updateSummaryBuilder.addDeletes(deletes);
    }

    public UpdateSummary getUpdateSummary() {
        return this._updateSummaryBuilder.build();
    }
}

