/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import java.util.Date;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.RowNumberQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.FormatHelper;
import org.apache.metamodel.util.TimeComparator;

public class DB2QueryRewriter
extends RowNumberQueryRewriter {
    public DB2QueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public String escapeQuotes(String filterItemOperand) {
        return filterItemOperand.replaceAll("\\'", "\\\\'");
    }

    @Override
    public boolean isSchemaIncludedInColumnPaths() {
        return true;
    }

    @Override
    public boolean isMaxRowsSupported() {
        return true;
    }

    @Override
    public boolean isFirstRowSupported(Query query) {
        return true;
    }

    @Override
    public String rewriteQuery(Query query) {
        Integer firstRow = query.getFirstRow();
        Integer maxRows = query.getMaxRows();
        if (maxRows == null && (firstRow == null || firstRow == 1)) {
            return super.rewriteQuery(query);
        }
        if ((firstRow == null || firstRow == 1) && maxRows != null && maxRows > 0) {
            return super.rewriteQuery(query) + " FETCH FIRST " + maxRows + " ROWS ONLY";
        }
        return this.getRowNumberSql(query, maxRows, firstRow);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.BOOLEAN || columnType == ColumnType.BIT) {
            return "SMALLINT";
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        ColumnType columnType;
        SelectItem selectItem = item.getSelectItem();
        Object itemOperand = item.getOperand();
        OperatorType operator = item.getOperator();
        if (null != selectItem && itemOperand != null && (columnType = selectItem.getExpectedColumnType()) != null && columnType.isTimeBased()) {
            StringBuilder sb = new StringBuilder();
            sb.append(selectItem.getSameQueryAlias(true));
            Object operand = FilterItem.appendOperator((StringBuilder)sb, (Object)itemOperand, (OperatorType)operator);
            if (operand instanceof SelectItem) {
                String selectItemString = ((SelectItem)operand).getSameQueryAlias(true);
                sb.append(selectItemString);
            } else {
                Date date = TimeComparator.toDate((Object)itemOperand);
                if (date == null) {
                    throw new IllegalStateException("Could not convert " + itemOperand + " to date");
                }
                String sqlValue = FormatHelper.formatSqlTime((ColumnType)columnType, (Date)date, (boolean)true, (String)"('", (String)"')");
                sb.append(sqlValue);
            }
            return sb.toString();
        }
        return super.rewriteFilterItem(item);
    }
}

