/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo2;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.mongodb.common.MongoDBUtils;
import org.apache.metamodel.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDbDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDataSet.class);
    private final DBCursor _cursor;
    private final boolean _queryPostProcessed;
    private boolean _closed;
    private volatile DBObject _dbObject;

    public MongoDbDataSet(DBCursor cursor, Column[] columns, boolean queryPostProcessed) {
        super(columns);
        this._cursor = cursor;
        this._queryPostProcessed = queryPostProcessed;
        this._closed = false;
    }

    public boolean isQueryPostProcessed() {
        return this._queryPostProcessed;
    }

    public void close() {
        super.close();
        this._cursor.close();
        this._closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    public boolean next() {
        if (this._cursor.hasNext()) {
            this._dbObject = this._cursor.next();
            return true;
        }
        this._dbObject = null;
        return false;
    }

    public Row getRow() {
        return MongoDBUtils.toRow((DBObject)this._dbObject, (DataSetHeader)this.getHeader());
    }
}

