/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo2;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.InMemoryDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.mongodb.common.MongoDBUtils;
import org.apache.metamodel.mongodb.common.MongoDbTableDef;
import org.apache.metamodel.mongodb.mongo2.DefaultWriteConcernAdvisor;
import org.apache.metamodel.mongodb.mongo2.MongoDbDataSet;
import org.apache.metamodel.mongodb.mongo2.MongoDbUpdateCallback;
import org.apache.metamodel.mongodb.mongo2.SimpleWriteConcernAdvisor;
import org.apache.metamodel.mongodb.mongo2.WriteConcernAdvisor;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDataSet.class);
    private final DB _mongoDb;
    private final SimpleTableDef[] _tableDefs;
    private WriteConcernAdvisor _writeConcernAdvisor;
    private Schema _schema;

    @Deprecated
    public MongoDbDataContext(DB mongoDb, MongoDbTableDef ... tableDefs) {
        this(mongoDb, (SimpleTableDef[])tableDefs);
    }

    public MongoDbDataContext(DB mongoDb, SimpleTableDef ... tableDefs) {
        this._mongoDb = mongoDb;
        this._tableDefs = tableDefs;
        this._schema = null;
    }

    public MongoDbDataContext(DB mongoDb) {
        this(mongoDb, MongoDbDataContext.detectSchema(mongoDb));
    }

    public static SimpleTableDef[] detectSchema(DB db) {
        Set collectionNames = db.getCollectionNames();
        SimpleTableDef[] result = new SimpleTableDef[collectionNames.size()];
        int i = 0;
        for (String collectionName : collectionNames) {
            SimpleTableDef table;
            result[i] = table = MongoDbDataContext.detectTable(db, collectionName);
            ++i;
        }
        return result;
    }

    public static SimpleTableDef detectTable(DB db, String collectionName) {
        DBCollection collection = db.getCollection(collectionName);
        DBCursor cursor = collection.find().limit(1000);
        TreeMap columnsAndTypes = new TreeMap();
        while (cursor.hasNext()) {
            DBObject object = cursor.next();
            Set keysInObject = object.keySet();
            for (String key : keysInObject) {
                Object value;
                HashSet types = (HashSet)columnsAndTypes.get(key);
                if (types == null) {
                    types = new HashSet();
                    columnsAndTypes.put(key, types);
                }
                if ((value = object.get(key)) == null) continue;
                types.add(value.getClass());
            }
        }
        cursor.close();
        String[] columnNames = new String[columnsAndTypes.size()];
        ColumnType[] columnTypes = new ColumnType[columnsAndTypes.size()];
        int i = 0;
        for (Map.Entry columnAndTypes : columnsAndTypes.entrySet()) {
            String columnName = (String)columnAndTypes.getKey();
            Set columnTypeSet = (Set)columnAndTypes.getValue();
            Class columnType = columnTypeSet.size() == 1 ? (Class)columnTypeSet.iterator().next() : Object.class;
            columnNames[i] = columnName;
            columnTypes[i] = columnType == ObjectId.class ? ColumnType.ROWID : ColumnTypeImpl.convertColumnType((Class)columnType);
            ++i;
        }
        return new SimpleTableDef(collectionName, columnNames, columnTypes);
    }

    protected Schema getMainSchema() throws MetaModelException {
        if (this._schema == null) {
            MutableSchema schema = new MutableSchema(this.getMainSchemaName());
            for (SimpleTableDef tableDef : this._tableDefs) {
                Column[] rowIdColumns;
                MutableTable table = tableDef.toTable().setSchema((Schema)schema);
                for (Column column : rowIdColumns = table.getColumnsOfType(ColumnType.ROWID)) {
                    if (!(column instanceof MutableColumn)) continue;
                    ((MutableColumn)column).setPrimaryKey(true);
                }
                schema.addTable(table);
            }
            this._schema = schema;
        }
        return this._schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._mongoDb.getName();
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        DBCollection collection = this._mongoDb.getCollection(table.getName());
        BasicDBObject query = this.createMongoDbQuery(table, whereItems);
        logger.info("Executing MongoDB 'count' query: {}", (Object)query);
        long count = collection.count((DBObject)query);
        return count;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        DBCollection collection = this._mongoDb.getCollection(table.getName());
        ArrayList<FilterItem> whereItems = new ArrayList<FilterItem>();
        SelectItem selectItem = new SelectItem(primaryKeyColumn);
        FilterItem primaryKeyWhereItem = new FilterItem(selectItem, OperatorType.EQUALS_TO, keyValue);
        whereItems.add(primaryKeyWhereItem);
        BasicDBObject query = this.createMongoDbQuery(table, whereItems);
        DBObject resultDBObject = collection.findOne((DBObject)query);
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        Row row = MongoDBUtils.toRow((DBObject)resultDBObject, (DataSetHeader)header);
        return row;
    }

    public DataSet executeQuery(Query query) {
        List fromItems = query.getFromClause().getItems();
        if (fromItems.size() == 1 && ((FromItem)fromItems.get(0)).getTable() != null && ((FromItem)fromItems.get(0)).getTable().getSchema() == this._schema) {
            Table table = ((FromItem)fromItems.get(0)).getTable();
            if (query.getGroupByClause().isEmpty() && query.getHavingClause().isEmpty() && query.getOrderByClause().isEmpty()) {
                List whereItems = query.getWhereClause().getItems();
                boolean allSelectItemsAreColumns = true;
                List selectItems = query.getSelectClause().getItems();
                for (SelectItem selectItem : selectItems) {
                    if (selectItem.getAggregateFunction() == null && selectItem.getScalarFunction() == null && selectItem.getColumn() != null) continue;
                    allSelectItemsAreColumns = false;
                    break;
                }
                if (allSelectItemsAreColumns) {
                    logger.debug("Query can be expressed in full MongoDB, no post processing needed.");
                    Column[] columns = new Column[selectItems.size()];
                    for (int i = 0; i < columns.length; ++i) {
                        columns[i] = ((SelectItem)selectItems.get(i)).getColumn();
                    }
                    if (whereItems.size() == 1) {
                        Column column;
                        FilterItem whereItem = (FilterItem)whereItems.get(0);
                        SelectItem selectItem = whereItem.getSelectItem();
                        if (!whereItem.isCompoundFilter() && selectItem != null && selectItem.getColumn() != null && (column = selectItem.getColumn()).isPrimaryKey() && OperatorType.EQUALS_TO.equals(whereItem.getOperator())) {
                            logger.debug("Query is a primary key lookup query. Trying executePrimaryKeyLookupQuery(...)");
                            Object operand = whereItem.getOperand();
                            Row row = this.executePrimaryKeyLookupQuery(table, selectItems, column, operand);
                            if (row == null) {
                                logger.debug("DataContext did not return any primary key lookup query results. Proceeding with manual lookup.");
                            } else {
                                SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
                                return new InMemoryDataSet((DataSetHeader)header, new Row[]{row});
                            }
                        }
                    }
                    int firstRow = query.getFirstRow() == null ? 1 : query.getFirstRow();
                    int maxRows = query.getMaxRows() == null ? -1 : query.getMaxRows();
                    boolean thereIsAtLeastOneAlias = false;
                    for (SelectItem selectItem : selectItems) {
                        if (selectItem.getAlias() == null) continue;
                        thereIsAtLeastOneAlias = true;
                        break;
                    }
                    if (thereIsAtLeastOneAlias) {
                        SelectItem[] selectItemsAsArray = selectItems.toArray(new SelectItem[selectItems.size()]);
                        DataSet dataSet = this.materializeMainSchemaTableInternal(table, selectItemsAsArray, (List<FilterItem>)whereItems, firstRow, maxRows, false);
                        return dataSet;
                    }
                    DataSet dataSet = this.materializeMainSchemaTableInternal(table, columns, (List<FilterItem>)whereItems, firstRow, maxRows, false);
                    return dataSet;
                }
            }
        }
        logger.debug("Query will be simplified for MongoDB and post processed.");
        return super.executeQuery(query);
    }

    private DataSet materializeMainSchemaTableInternal(Table table, Column[] columns, List<FilterItem> whereItems, int firstRow, int maxRows, boolean queryPostProcessed) {
        DBCursor cursor = this.getCursor(table, whereItems, firstRow, maxRows);
        return new MongoDbDataSet(cursor, columns, queryPostProcessed);
    }

    private DataSet materializeMainSchemaTableInternal(Table table, SelectItem[] selectItems, List<FilterItem> whereItems, int firstRow, int maxRows, boolean queryPostProcessed) {
        DBCursor cursor = this.getCursor(table, whereItems, firstRow, maxRows);
        return new MongoDbDataSet(cursor, selectItems, queryPostProcessed);
    }

    private DBCursor getCursor(Table table, List<FilterItem> whereItems, int firstRow, int maxRows) {
        DBCollection collection = this._mongoDb.getCollection(table.getName());
        BasicDBObject query = this.createMongoDbQuery(table, whereItems);
        logger.info("Executing MongoDB 'find' query: {}", (Object)query);
        DBCursor cursor = collection.find((DBObject)query);
        if (maxRows > 0) {
            cursor = cursor.limit(maxRows);
        }
        if (firstRow > 1) {
            int skip = firstRow - 1;
            cursor = cursor.skip(skip);
        }
        return cursor;
    }

    protected BasicDBObject createMongoDbQuery(Table table, List<FilterItem> whereItems) {
        assert (this._schema == table.getSchema());
        BasicDBObject query = new BasicDBObject();
        if (whereItems != null && !whereItems.isEmpty()) {
            for (FilterItem item : whereItems) {
                this.convertToCursorObject(query, item);
            }
        }
        return query;
    }

    private void convertToCursorObject(BasicDBObject query, FilterItem item) {
        if (item.isCompoundFilter()) {
            FilterItem[] childItems;
            BasicDBList orList = new BasicDBList();
            for (FilterItem childItem : childItems = item.getChildItems()) {
                BasicDBObject childObject = new BasicDBObject();
                this.convertToCursorObject(childObject, childItem);
                orList.add((Object)childObject);
            }
            query.put("$or", (Object)orList);
        } else {
            BasicDBObject existingFilterObject;
            Column column = item.getSelectItem().getColumn();
            String columnName = column.getName();
            String operatorName = this.getOperatorName(item);
            Object operand = item.getOperand();
            if (ObjectId.isValid((String)String.valueOf(operand))) {
                operand = new ObjectId(String.valueOf(operand));
            }
            if ((existingFilterObject = (BasicDBObject)query.get(columnName)) == null) {
                if (operatorName == null) {
                    if (OperatorType.LIKE.equals(item.getOperator())) {
                        query.put(columnName, (Object)this.turnOperandIntoRegExp(operand));
                    } else {
                        query.put(columnName, operand);
                    }
                } else {
                    query.put(columnName, (Object)new BasicDBObject(operatorName, operand));
                }
            } else {
                if (operatorName == null) {
                    throw new IllegalStateException("Cannot retrieve records for a column with two EQUALS_TO operators");
                }
                existingFilterObject.append(operatorName, operand);
            }
        }
    }

    private String getOperatorName(FilterItem item) {
        OperatorType operator = item.getOperator();
        if (OperatorType.EQUALS_TO.equals(operator)) {
            return null;
        }
        if (OperatorType.LIKE.equals(operator)) {
            return null;
        }
        if (OperatorType.LESS_THAN.equals(operator)) {
            return "$lt";
        }
        if (OperatorType.LESS_THAN_OR_EQUAL.equals(operator)) {
            return "$lte";
        }
        if (OperatorType.GREATER_THAN.equals(operator)) {
            return "$gt";
        }
        if (OperatorType.GREATER_THAN_OR_EQUAL.equals(operator)) {
            return "$gte";
        }
        if (OperatorType.DIFFERENT_FROM.equals(operator)) {
            return "$ne";
        }
        if (OperatorType.IN.equals(operator)) {
            return "$in";
        }
        throw new IllegalStateException("Unsupported operator type: " + operator);
    }

    private Pattern turnOperandIntoRegExp(Object operand) {
        StringBuilder operandAsRegExp = new StringBuilder(this.replaceWildCardLikeChars(operand.toString()));
        operandAsRegExp.insert(0, "^").append("$");
        return Pattern.compile(operandAsRegExp.toString(), 2);
    }

    private String replaceWildCardLikeChars(String operand) {
        return operand.replaceAll("%", ".*");
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        return this.materializeMainSchemaTableInternal(table, columns, null, 1, maxRows, true);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int firstRow, int maxRows) {
        return this.materializeMainSchemaTableInternal(table, columns, null, firstRow, maxRows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript update, WriteConcernAdvisor writeConcernAdvisor) {
        try (MongoDbUpdateCallback callback = new MongoDbUpdateCallback(this, writeConcernAdvisor);){
            update.run((UpdateCallback)callback);
        }
    }

    public void executeUpdate(UpdateScript update, WriteConcern writeConcern) {
        this.executeUpdate(update, new SimpleWriteConcernAdvisor(writeConcern));
    }

    public void executeUpdate(UpdateScript update) {
        this.executeUpdate(update, this.getWriteConcernAdvisor());
    }

    public WriteConcernAdvisor getWriteConcernAdvisor() {
        if (this._writeConcernAdvisor == null) {
            return new DefaultWriteConcernAdvisor();
        }
        return this._writeConcernAdvisor;
    }

    public void setWriteConcernAdvisor(WriteConcernAdvisor writeConcernAdvisor) {
        this._writeConcernAdvisor = writeConcernAdvisor;
    }

    public DB getMongoDb() {
        return this._mongoDb;
    }

    protected void addTable(MutableTable table) {
        if (!(this._schema instanceof MutableSchema)) {
            throw new UnsupportedOperationException("Schema is not mutable");
        }
        MutableSchema mutableSchema = (MutableSchema)this._schema;
        mutableSchema.addTable(table);
    }
}

