/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo3;

import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.InMemoryDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.mongodb.common.MongoDBUtils;
import org.apache.metamodel.mongodb.mongo3.DefaultWriteConcernAdvisor;
import org.apache.metamodel.mongodb.mongo3.MongoDbDataSet;
import org.apache.metamodel.mongodb.mongo3.MongoDbUpdateCallback;
import org.apache.metamodel.mongodb.mongo3.SimpleWriteConcernAdvisor;
import org.apache.metamodel.mongodb.mongo3.WriteConcernAdvisor;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDataSet.class);
    private final MongoDatabase _mongoDb;
    private final SimpleTableDef[] _tableDefs;
    private WriteConcernAdvisor _writeConcernAdvisor;
    private Schema _schema;

    public MongoDbDataContext(MongoDatabase mongoDb, SimpleTableDef ... tableDefs) {
        super(false);
        this._mongoDb = mongoDb;
        this._tableDefs = tableDefs;
        this._schema = null;
    }

    public MongoDbDataContext(MongoDatabase mongoDb) {
        this(mongoDb, MongoDbDataContext.detectSchema(mongoDb));
    }

    public static SimpleTableDef[] detectSchema(MongoDatabase mongoDb) {
        MongoIterable collectionNames = mongoDb.listCollectionNames();
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        for (String collectionName : collectionNames) {
            SimpleTableDef table = MongoDbDataContext.detectTable(mongoDb, collectionName);
            result.add(table);
        }
        return result.toArray(new SimpleTableDef[0]);
    }

    public static SimpleTableDef detectTable(MongoDatabase mongoDb, String collectionName) {
        MongoCollection collection = mongoDb.getCollection(collectionName);
        FindIterable iterable = collection.find().limit(1000);
        TreeMap columnsAndTypes = new TreeMap();
        for (Document document : iterable) {
            Set keysInObject = document.keySet();
            for (String string : keysInObject) {
                Object value;
                HashSet types = (HashSet)columnsAndTypes.get(string);
                if (types == null) {
                    types = new HashSet();
                    columnsAndTypes.put(string, types);
                }
                if ((value = document.get((Object)string)) == null) continue;
                types.add(value.getClass());
            }
        }
        String[] columnNames = new String[columnsAndTypes.size()];
        ColumnType[] columnTypes = new ColumnType[columnsAndTypes.size()];
        int i = 0;
        for (Map.Entry entry : columnsAndTypes.entrySet()) {
            String columnName = (String)entry.getKey();
            Set columnTypeSet = (Set)entry.getValue();
            Class columnType = columnTypeSet.size() == 1 ? (Class)columnTypeSet.iterator().next() : Object.class;
            columnNames[i] = columnName;
            columnTypes[i] = columnType == ObjectId.class ? ColumnType.ROWID : ColumnTypeImpl.convertColumnType((Class)columnType);
            ++i;
        }
        return new SimpleTableDef(collectionName, columnNames, columnTypes);
    }

    protected Schema getMainSchema() throws MetaModelException {
        if (this._schema == null) {
            MutableSchema schema = new MutableSchema(this.getMainSchemaName());
            for (SimpleTableDef tableDef : this._tableDefs) {
                MutableTable table = tableDef.toTable().setSchema((Schema)schema);
                List rowIdColumns = table.getColumnsOfType(ColumnType.ROWID);
                for (Column column : rowIdColumns) {
                    if (!(column instanceof MutableColumn)) continue;
                    ((MutableColumn)column).setPrimaryKey(true);
                }
                schema.addTable((Table)table);
            }
            this._schema = schema;
        }
        return this._schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._mongoDb.getName();
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        MongoCollection collection = this._mongoDb.getCollection(table.getName());
        ArrayList postProcessFilters = new ArrayList();
        Document query = this.createMongoDbQuery(table, whereItems, whereItem -> postProcessFilters.add(whereItem));
        if (!postProcessFilters.isEmpty()) {
            return null;
        }
        logger.info("Executing MongoDB 'count' query: {}", (Object)query);
        long count = collection.count((Bson)query);
        return count;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        MongoCollection collection = this._mongoDb.getCollection(table.getName());
        ArrayList<FilterItem> whereItems = new ArrayList<FilterItem>();
        SelectItem selectItem = new SelectItem(primaryKeyColumn);
        FilterItem primaryKeyWhereItem = new FilterItem(selectItem, OperatorType.EQUALS_TO, keyValue);
        whereItems.add(primaryKeyWhereItem);
        Document query = this.createMongoDbQuery(table, whereItems, null);
        Document resultDoc = (Document)collection.find((Bson)query).first();
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        Row row = MongoDBUtils.toRow((Map)resultDoc, (DataSetHeader)header);
        return row;
    }

    public DataSet executeQuery(Query query) {
        List fromItems = query.getFromClause().getItems();
        if (fromItems.size() == 1 && ((FromItem)fromItems.get(0)).getTable() != null && ((FromItem)fromItems.get(0)).getTable().getSchema() == this._schema) {
            Table table = ((FromItem)fromItems.get(0)).getTable();
            if (query.getGroupByClause().isEmpty() && query.getHavingClause().isEmpty() && query.getOrderByClause().isEmpty()) {
                List whereItems = query.getWhereClause().getItems();
                boolean allSelectItemsAreColumns = true;
                List selectItems = query.getSelectClause().getItems();
                for (SelectItem selectItem : selectItems) {
                    if (!selectItem.hasFunction() && selectItem.getColumn() != null) continue;
                    allSelectItemsAreColumns = false;
                    break;
                }
                if (allSelectItemsAreColumns) {
                    DataSet dataSet;
                    logger.debug("Query can be expressed in full MongoDB, no post processing needed.");
                    if (whereItems.size() == 1) {
                        Column column;
                        SelectItem selectItem;
                        FilterItem whereItem = (FilterItem)whereItems.get(0);
                        selectItem = whereItem.getSelectItem();
                        if (!whereItem.isCompoundFilter() && selectItem != null && selectItem.getColumn() != null && (column = selectItem.getColumn()).isPrimaryKey() && OperatorType.EQUALS_TO.equals(whereItem.getOperator())) {
                            logger.debug("Query is a primary key lookup query. Trying executePrimaryKeyLookupQuery(...)");
                            Object operand = whereItem.getOperand();
                            Row row = this.executePrimaryKeyLookupQuery(table, selectItems, column, operand);
                            if (row == null) {
                                logger.debug("DataContext did not return any primary key lookup query results. Proceeding with manual lookup.");
                            } else {
                                SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
                                return new InMemoryDataSet((DataSetHeader)header, new Row[]{row});
                            }
                        }
                    }
                    int firstRow = query.getFirstRow() == null ? 1 : query.getFirstRow();
                    int maxRows = query.getMaxRows() == null ? -1 : query.getMaxRows();
                    boolean thereIsAtLeastOneAlias = false;
                    for (SelectItem selectItem : selectItems) {
                        if (selectItem.getAlias() == null) continue;
                        thereIsAtLeastOneAlias = true;
                        break;
                    }
                    if (thereIsAtLeastOneAlias) {
                        dataSet = this.materializeMainSchemaTableInternal(table, selectItems, whereItems, firstRow, maxRows, false);
                        return dataSet;
                    }
                    dataSet = this.materializeMainSchemaTableInternal(table, selectItems, whereItems, firstRow, maxRows, false);
                    return dataSet;
                }
            }
        }
        logger.debug("Query will be simplified for MongoDB and post processed.");
        return super.executeQuery(query);
    }

    private DataSet materializeMainSchemaTableInternal(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows, boolean queryPostProcessed) {
        MongoDbDataSet dataSet;
        ArrayList postProcessWhereItems = new ArrayList();
        MongoCursor<Document> cursor = this.getDocumentMongoCursor(table, whereItems, firstRow, maxRows, whereItem -> postProcessWhereItems.add(whereItem));
        if (postProcessWhereItems.isEmpty()) {
            dataSet = new MongoDbDataSet(cursor, selectItems, queryPostProcessed);
        } else {
            ArrayList<SelectItem> selectItemsToQuery = new ArrayList<SelectItem>(selectItems);
            postProcessWhereItems.forEach(whereItem -> {
                Column column = whereItem.getSelectItem().getColumn();
                if (column != null) {
                    selectItemsToQuery.add(new SelectItem(column));
                }
            });
            MongoDbDataSet innerDataSet1 = new MongoDbDataSet(cursor, selectItemsToQuery, queryPostProcessed);
            DataSet innerDataSet2 = MetaModelHelper.getFiltered((DataSet)innerDataSet1, postProcessWhereItems);
            dataSet = MetaModelHelper.getSelection(selectItems, (DataSet)innerDataSet2);
        }
        return dataSet;
    }

    private MongoCursor<Document> getDocumentMongoCursor(Table table, List<FilterItem> whereItems, int firstRow, int maxRows, Consumer<FilterItem> filterItemsToPostProcessConsumer) {
        MongoCollection collection = this._mongoDb.getCollection(table.getName());
        Document query = this.createMongoDbQuery(table, whereItems, filterItemsToPostProcessConsumer);
        logger.info("Executing MongoDB 'find' query: {}", (Object)query);
        FindIterable iterable = collection.find((Bson)query);
        if (maxRows > 0) {
            iterable = iterable.limit(maxRows);
        }
        if (firstRow > 1) {
            int skip = firstRow - 1;
            iterable = iterable.skip(skip);
        }
        return iterable.iterator();
    }

    protected Document createMongoDbQuery(Table table, List<FilterItem> whereItems, Consumer<FilterItem> whereItemToPostProcessConsumer) {
        assert (this._schema == table.getSchema());
        Document query = new Document();
        if (whereItems != null && !whereItems.isEmpty()) {
            for (FilterItem item : whereItems) {
                boolean converted = this.convertToCursorObject(query, item);
                if (converted) continue;
                whereItemToPostProcessConsumer.accept(item);
            }
        }
        return query;
    }

    private static Object convertArrayToList(Object arr) {
        if (arr instanceof boolean[]) {
            return Arrays.asList(new boolean[][]{(boolean[])arr});
        }
        if (arr instanceof byte[]) {
            return Arrays.asList(new byte[][]{(byte[])arr});
        }
        if (arr instanceof short[]) {
            return Arrays.asList(new short[][]{(short[])arr});
        }
        if (arr instanceof char[]) {
            return Arrays.asList(new char[][]{(char[])arr});
        }
        if (arr instanceof int[]) {
            return Arrays.asList(new int[][]{(int[])arr});
        }
        if (arr instanceof long[]) {
            return Arrays.asList(new long[][]{(long[])arr});
        }
        if (arr instanceof float[]) {
            return Arrays.asList(new float[][]{(float[])arr});
        }
        if (arr instanceof double[]) {
            return Arrays.asList(new double[][]{(double[])arr});
        }
        if (arr instanceof Object[]) {
            return Arrays.asList((Object[])arr);
        }
        return null;
    }

    private boolean convertToCursorObject(Document query, FilterItem item) {
        String operatorName;
        if (item.isCompoundFilter()) {
            FilterItem[] childItems;
            ArrayList<Document> orList = new ArrayList<Document>();
            FilterItem[] filterItemArray = childItems = item.getChildItems();
            int n = filterItemArray.length;
            for (int i = 0; i < n; ++i) {
                Document childDoc = new Document();
                FilterItem childItem = filterItemArray[i];
                boolean converted = this.convertToCursorObject(childDoc, childItem);
                if (!converted) {
                    return false;
                }
                orList.add(childDoc);
            }
            query.put("$or", orList);
            return true;
        }
        SelectItem selectItem = item.getSelectItem();
        if (selectItem.hasFunction()) {
            return false;
        }
        Column column = selectItem.getColumn();
        String columnName = column.getName();
        try {
            operatorName = this.getOperatorName(item);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        Object operand = item.getOperand();
        if (ObjectId.isValid((String)String.valueOf(operand))) {
            operand = new ObjectId(String.valueOf(operand));
        } else if (operand != null && operand.getClass().isArray()) {
            operand = MongoDbDataContext.convertArrayToList(operand);
        }
        Document existingFilterObject = (Document)query.get((Object)columnName);
        if (existingFilterObject == null) {
            if (operatorName == null) {
                if (OperatorType.LIKE.equals(item.getOperator())) {
                    query.put(columnName, (Object)this.turnOperandIntoRegExp(operand));
                } else {
                    query.put(columnName, operand);
                }
            } else {
                query.put(columnName, (Object)new Document(operatorName, operand));
            }
        } else {
            if (operatorName == null) {
                throw new IllegalStateException("Cannot retrieve records for a column with two EQUALS_TO operators");
            }
            existingFilterObject.append(operatorName, operand);
        }
        return true;
    }

    private String getOperatorName(FilterItem item) throws UnsupportedOperationException {
        OperatorType operator = item.getOperator();
        if (OperatorType.EQUALS_TO.equals(operator)) {
            return null;
        }
        if (OperatorType.LIKE.equals(operator)) {
            return null;
        }
        if (OperatorType.LESS_THAN.equals(operator)) {
            return "$lt";
        }
        if (OperatorType.LESS_THAN_OR_EQUAL.equals(operator)) {
            return "$lte";
        }
        if (OperatorType.GREATER_THAN.equals(operator)) {
            return "$gt";
        }
        if (OperatorType.GREATER_THAN_OR_EQUAL.equals(operator)) {
            return "$gte";
        }
        if (OperatorType.DIFFERENT_FROM.equals(operator)) {
            return "$ne";
        }
        if (OperatorType.IN.equals(operator)) {
            return "$in";
        }
        throw new UnsupportedOperationException("Unsupported operator type: " + operator);
    }

    private Pattern turnOperandIntoRegExp(Object operand) {
        StringBuilder operandAsRegExp = new StringBuilder(this.replaceWildCardLikeChars(operand.toString()));
        operandAsRegExp.insert(0, "^").append("$");
        return Pattern.compile(operandAsRegExp.toString(), 2);
    }

    private String replaceWildCardLikeChars(String operand) {
        return operand.replaceAll("%", ".*");
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        return this.materializeMainSchemaTableInternal(table, columns.stream().map(SelectItem::new).collect(Collectors.toList()), null, 1, maxRows, true);
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int firstRow, int maxRows) {
        return this.materializeMainSchemaTableInternal(table, columns.stream().map(SelectItem::new).collect(Collectors.toList()), null, firstRow, maxRows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSummary executeUpdate(UpdateScript update, WriteConcernAdvisor writeConcernAdvisor) {
        try (MongoDbUpdateCallback callback = new MongoDbUpdateCallback(this, writeConcernAdvisor);){
            update.run((UpdateCallback)callback);
        }
        return callback.getUpdateSummary();
    }

    public UpdateSummary executeUpdate(UpdateScript update, WriteConcern writeConcern) {
        return this.executeUpdate(update, new SimpleWriteConcernAdvisor(writeConcern));
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        return this.executeUpdate(update, this.getWriteConcernAdvisor());
    }

    public WriteConcernAdvisor getWriteConcernAdvisor() {
        if (this._writeConcernAdvisor == null) {
            return new DefaultWriteConcernAdvisor();
        }
        return this._writeConcernAdvisor;
    }

    public void setWriteConcernAdvisor(WriteConcernAdvisor writeConcernAdvisor) {
        this._writeConcernAdvisor = writeConcernAdvisor;
    }

    public MongoDatabase getMongoDb() {
        return this._mongoDb;
    }

    protected void addTable(MutableTable table) {
        if (!(this._schema instanceof MutableSchema)) {
            throw new UnsupportedOperationException("Schema is not mutable");
        }
        MutableSchema mutableSchema = (MutableSchema)this._schema;
        mutableSchema.addTable((Table)table);
    }
}

