/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo3;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.mongodb.mongo3.MongoDbUpdateCallback;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDbInsertionBuilder
extends AbstractRowInsertionBuilder<MongoDbUpdateCallback>
implements RowInsertionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbInsertionBuilder.class);

    public MongoDbInsertionBuilder(MongoDbUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        Document doc = new Document();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            doc.put(columns[i].getName(), value);
        }
        MongoDbUpdateCallback updateCallback = (MongoDbUpdateCallback)this.getUpdateCallback();
        MongoCollection<Document> collection = updateCallback.getCollection(this.getTable().getName());
        WriteConcern writeConcern = updateCallback.getWriteConcernAdvisor().adviceInsert(collection, doc);
        collection.withWriteConcern(writeConcern);
        collection.insertOne((Object)doc);
        logger.info("Document has been inserted");
    }
}

