/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.neo4j;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

public class Neo4jCypherQueryBuilder {
    public static String buildSelectQuery(Table table, Column[] columns, int firstRow, int maxRows) {
        String[] columnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnNames[i] = columns[i].getName();
        }
        return Neo4jCypherQueryBuilder.buildSelectQuery(table.getName(), columnNames, firstRow, maxRows);
    }

    public static String buildSelectQuery(String tableName, String[] columnNames, int firstRow, int maxRows) {
        LinkedHashMap<String, String> returnClauseMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Integer> relationshipIndexMap = new LinkedHashMap<String, Integer>();
        for (String columnName : columnNames) {
            if (columnName.startsWith("rel_")) {
                String relationshipAlias;
                String relationshipPropertyName;
                String relationshipName;
                if ((columnName = columnName.replace("rel_", "")).contains("#")) {
                    String[] parsedColumnNameArray = columnName.split("#");
                    relationshipName = parsedColumnNameArray[0];
                    relationshipPropertyName = parsedColumnNameArray[1];
                } else {
                    relationshipName = columnName;
                    relationshipPropertyName = "metamodel_neo4j_relationship_marker";
                }
                if (relationshipIndexMap.containsKey(relationshipName)) {
                    relationshipAlias = "r" + relationshipIndexMap.get(relationshipName);
                } else {
                    int nextIndex = relationshipIndexMap.values().isEmpty() ? 0 : (Integer)Collections.max(relationshipIndexMap.values()) + 1;
                    relationshipIndexMap.put(relationshipName, nextIndex);
                    relationshipAlias = "r" + relationshipIndexMap.get(relationshipName);
                }
                if (relationshipPropertyName.equals("metamodel_neo4j_relationship_marker")) {
                    returnClauseMap.put(columnName, "id(" + relationshipAlias + "_relationshipEndNode)");
                    continue;
                }
                returnClauseMap.put(columnName, relationshipAlias + "." + relationshipPropertyName);
                continue;
            }
            if (columnName.equals("_id")) {
                returnClauseMap.put(columnName, "id(n)");
                continue;
            }
            returnClauseMap.put(columnName, "n." + columnName);
        }
        StringBuilder cypherBuilder = new StringBuilder();
        cypherBuilder.append("MATCH (n:");
        cypherBuilder.append(tableName);
        for (Map.Entry relationshipAliasEntry : relationshipIndexMap.entrySet()) {
            cypherBuilder.append(") OPTIONAL MATCH (n)-[r" + relationshipAliasEntry.getValue() + ":" + (String)relationshipAliasEntry.getKey() + "]->(r" + relationshipAliasEntry.getValue() + "_relationshipEndNode");
        }
        cypherBuilder.append(") RETURN ");
        boolean addComma = false;
        for (Map.Entry returnClauseEntry : returnClauseMap.entrySet()) {
            if (addComma) {
                cypherBuilder.append(",");
            }
            cypherBuilder.append((String)returnClauseEntry.getValue());
            addComma = true;
        }
        if (firstRow > 1) {
            cypherBuilder.append(" SKIP " + (firstRow - 1));
        }
        if (maxRows > -1) {
            cypherBuilder.append(" LIMIT " + maxRows);
        }
        return cypherBuilder.toString();
    }

    public static String buildCountQuery(String tableName, List<FilterItem> whereItems) {
        StringBuilder cypherBuilder = new StringBuilder();
        cypherBuilder.append("MATCH (n:");
        cypherBuilder.append(tableName);
        cypherBuilder.append(") ");
        cypherBuilder.append(Neo4jCypherQueryBuilder.buildWhereClause(whereItems, "n"));
        cypherBuilder.append(" RETURN COUNT(*);");
        return cypherBuilder.toString();
    }

    private static String buildWhereClause(List<FilterItem> whereItems, String queryObjectHandle) {
        if (whereItems != null && !whereItems.isEmpty()) {
            StringBuilder whereClauseBuilder = new StringBuilder();
            whereClauseBuilder.append("WHERE ");
            FilterItem firstWhereItem = whereItems.get(0);
            whereClauseBuilder.append(Neo4jCypherQueryBuilder.buildWhereClauseItem(firstWhereItem, queryObjectHandle));
            for (int i = 1; i < whereItems.size(); ++i) {
                whereClauseBuilder.append(" AND ");
                FilterItem whereItem = whereItems.get(i);
                whereClauseBuilder.append(Neo4jCypherQueryBuilder.buildWhereClauseItem(whereItem, queryObjectHandle));
            }
            return whereClauseBuilder.toString();
        }
        return "";
    }

    private static String buildWhereClauseItem(FilterItem whereItem, String queryObjectHandle) {
        StringBuilder whereClauseItemBuilder = new StringBuilder();
        whereClauseItemBuilder.append(queryObjectHandle);
        whereClauseItemBuilder.append(".");
        whereClauseItemBuilder.append(whereItem.getSelectItem().getColumn().getName());
        whereClauseItemBuilder.append(whereItem.getOperator().toSql());
        Object operand = whereItem.getOperand();
        if (operand instanceof String) {
            whereClauseItemBuilder.append("\"");
        }
        whereClauseItemBuilder.append(operand);
        if (operand instanceof String) {
            whereClauseItemBuilder.append("\"");
        }
        return whereClauseItemBuilder.toString();
    }
}

