/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.neo4j;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.neo4j.Neo4jCypherQueryBuilder;
import org.apache.metamodel.neo4j.Neo4jDataSet;
import org.apache.metamodel.neo4j.Neo4jRequestWrapper;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.util.SimpleTableDef;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jDataContext
extends QueryPostprocessDataContext
implements DataContext,
DocumentSourceProvider {
    public static final Logger logger = LoggerFactory.getLogger(Neo4jDataContext.class);
    public static final String SCHEMA_NAME = "neo4j";
    public static final int DEFAULT_PORT = 7474;
    public static final String RELATIONSHIP_PREFIX = "rel_";
    public static final String RELATIONSHIP_COLUMN_SEPARATOR = "#";
    private final SimpleTableDef[] _tableDefs;
    private final Neo4jRequestWrapper _requestWrapper;
    private final HttpHost _httpHost;
    private String _serviceRoot = "/db/data";

    public Neo4jDataContext(String hostname, int port, String username, String password, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = tableDefs;
    }

    public Neo4jDataContext(String hostname, int port, String username, String password, String serviceRoot, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = tableDefs;
        this._serviceRoot = serviceRoot;
    }

    public Neo4jDataContext(String hostname, int port, String username, String password) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
    }

    public Neo4jDataContext(String hostname, int port, String username, String password, String serviceRoot) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
        this._serviceRoot = serviceRoot;
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient, String serviceRoot) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
        this._serviceRoot = serviceRoot;
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = tableDefs;
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient, String serviceRoot, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = tableDefs;
        this._serviceRoot = serviceRoot;
    }

    protected String getDefaultSchemaName() throws MetaModelException {
        return SCHEMA_NAME;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        for (SimpleTableDef tableDef : this._tableDefs) {
            MutableTable table = tableDef.toTable().setSchema((Schema)schema);
            schema.addTable((Table)table);
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return SCHEMA_NAME;
    }

    public SimpleTableDef[] detectTableDefs() {
        ArrayList<SimpleTableDef> tableDefs = new ArrayList<SimpleTableDef>();
        String labelsJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(this._serviceRoot + "/labels"));
        try {
            JSONArray labelsJsonArray = new JSONArray(labelsJsonString);
            for (int i = 0; i < labelsJsonArray.length(); ++i) {
                String label = labelsJsonArray.getString(i);
                List<JSONObject> nodesPerLabel = this.getAllNodesPerLabel(label);
                ArrayList<String> propertiesPerLabel = new ArrayList<String>();
                for (JSONObject jSONObject : nodesPerLabel) {
                    List<String> propertiesPerNode = this.getAllPropertiesPerNode(jSONObject);
                    for (String property : propertiesPerNode) {
                        if (propertiesPerLabel.contains(property)) continue;
                        propertiesPerLabel.add(property);
                    }
                }
                LinkedHashSet<String> relationshipPropertiesPerLabel = new LinkedHashSet<String>();
                for (JSONObject node3 : nodesPerLabel) {
                    Integer nodeId = (Integer)node3.getJSONObject("metadata").get("id");
                    List<JSONObject> relationshipsPerNode = this.getOutgoingRelationshipsPerNode(nodeId);
                    for (JSONObject relationship : relationshipsPerNode) {
                        String relationshipName = relationship.getString("type");
                        String relationshipNameProperty = RELATIONSHIP_PREFIX + relationshipName;
                        if (!relationshipPropertiesPerLabel.contains(relationshipNameProperty)) {
                            relationshipPropertiesPerLabel.add(relationshipNameProperty);
                        }
                        List<String> propertiesPerRelationship = this.getAllPropertiesPerRelationship(relationship);
                        relationshipPropertiesPerLabel.addAll(propertiesPerRelationship);
                    }
                }
                propertiesPerLabel.addAll(relationshipPropertiesPerLabel);
                if (nodesPerLabel.isEmpty()) continue;
                SimpleTableDef simpleTableDef = new SimpleTableDef(label, propertiesPerLabel.toArray(new String[propertiesPerLabel.size()]));
                tableDefs.add(simpleTableDef);
            }
            return tableDefs.toArray(new SimpleTableDef[tableDefs.size()]);
        }
        catch (JSONException e) {
            logger.error("Error occured in parsing JSON while detecting the schema: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<String> getAllPropertiesPerRelationship(JSONObject relationship) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        try {
            String relationshipName = RELATIONSHIP_PREFIX + relationship.getJSONObject("metadata").getString("type");
            JSONObject relationshipPropertiesJSONObject = relationship.getJSONObject("data");
            if (relationshipPropertiesJSONObject.length() > 0) {
                JSONArray relationshipPropertiesNamesJSONArray = relationshipPropertiesJSONObject.names();
                for (int i = 0; i < relationshipPropertiesNamesJSONArray.length(); ++i) {
                    String propertyName = relationshipName + RELATIONSHIP_COLUMN_SEPARATOR + relationshipPropertiesNamesJSONArray.getString(i);
                    if (propertyNames.contains(propertyName)) continue;
                    propertyNames.add(propertyName);
                }
            }
            return propertyNames;
        }
        catch (JSONException e) {
            logger.error("Error occured in parsing JSON while getting relationship properties: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<JSONObject> getOutgoingRelationshipsPerNode(Integer nodeId) {
        ArrayList<JSONObject> outgoingRelationshipsPerNode = new ArrayList<JSONObject>();
        String outgoingRelationshipsPerNodeJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(this._serviceRoot + "/node/" + nodeId + "/relationships/out"));
        try {
            JSONArray outgoingRelationshipsPerNodeJsonArray = new JSONArray(outgoingRelationshipsPerNodeJsonString);
            for (int i = 0; i < outgoingRelationshipsPerNodeJsonArray.length(); ++i) {
                JSONObject relationship = outgoingRelationshipsPerNodeJsonArray.getJSONObject(i);
                if (outgoingRelationshipsPerNode.contains(relationship)) continue;
                outgoingRelationshipsPerNode.add(relationship);
            }
            return outgoingRelationshipsPerNode;
        }
        catch (JSONException e) {
            logger.error("Error occured in parsing JSON while detecting outgoing relationships for node: " + nodeId, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<JSONObject> getAllNodesPerLabel(String label) {
        ArrayList<JSONObject> allNodesPerLabel = new ArrayList<JSONObject>();
        String allNodesForLabelJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(this._serviceRoot + "/label/" + label + "/nodes"));
        try {
            JSONArray allNodesForLabelJsonArray = new JSONArray(allNodesForLabelJsonString);
            for (int i = 0; i < allNodesForLabelJsonArray.length(); ++i) {
                JSONObject node = allNodesForLabelJsonArray.getJSONObject(i);
                allNodesPerLabel.add(node);
            }
            return allNodesPerLabel;
        }
        catch (JSONException e) {
            logger.error("Error occured in parsing JSON while detecting the nodes for a label: " + label, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<String> getAllPropertiesPerNode(JSONObject node) {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("_id");
        try {
            String propertiesEndpoint = node.getString("properties");
            String allPropertiesPerNodeJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(propertiesEndpoint));
            JSONObject allPropertiesPerNodeJsonObject = new JSONObject(allPropertiesPerNodeJsonString);
            for (int j = 0; j < allPropertiesPerNodeJsonObject.length(); ++j) {
                JSONArray propertiesJsonArray = allPropertiesPerNodeJsonObject.names();
                for (int k = 0; k < propertiesJsonArray.length(); ++k) {
                    String property = propertiesJsonArray.getString(k);
                    properties.add(property);
                }
            }
            return properties;
        }
        catch (JSONException e) {
            logger.error("Error occured in parsing JSON while detecting the properties of a node: " + node, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int firstRow, int maxRows) {
        if (columns != null && columns.size() > 0) {
            Neo4jDataSet dataSet = null;
            try {
                String selectQuery = Neo4jCypherQueryBuilder.buildSelectQuery(table, columns, firstRow, maxRows);
                String responseJSONString = this._requestWrapper.executeCypherQuery(selectQuery);
                JSONObject resultJSONObject = new JSONObject(responseJSONString);
                List<SelectItem> selectItems = columns.stream().map(SelectItem::new).collect(Collectors.toList());
                dataSet = new Neo4jDataSet(selectItems, resultJSONObject);
            }
            catch (JSONException e) {
                logger.error("Error occured in parsing JSON while materializing the schema: ", (Throwable)e);
                throw new IllegalStateException(e);
            }
            return dataSet;
        }
        logger.error("Encountered null or empty columns array for materializing main schema table.");
        throw new IllegalArgumentException("Columns cannot be null or empty array");
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        return this.materializeMainSchemaTable(table, columns, 1, maxRows);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        String countQuery = Neo4jCypherQueryBuilder.buildCountQuery(table.getName(), whereItems);
        String jsonResponse = this._requestWrapper.executeCypherQuery(countQuery);
        try {
            JSONObject jsonResponseObject = new JSONObject(jsonResponse);
            JSONArray resultsJSONArray = jsonResponseObject.getJSONArray("results");
            JSONObject resultJSONObject = (JSONObject)resultsJSONArray.get(0);
            JSONArray dataJSONArray = resultJSONObject.getJSONArray("data");
            JSONObject rowJSONObject = (JSONObject)dataJSONArray.get(0);
            JSONArray valueJSONArray = rowJSONObject.getJSONArray("row");
            Number value = (Number)valueJSONArray.get(0);
            return value;
        }
        catch (JSONException e) {
            logger.error("Error occured in parsing JSON response: ", (Throwable)e);
            return null;
        }
    }

    public DocumentSource getMixedDocumentSourceForSampling() {
        return null;
    }

    public DocumentSource getDocumentSourceForTable(String sourceCollectionName) {
        return null;
    }
}

