/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.pojo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.pojo.PojoDataSet;
import org.apache.metamodel.pojo.PojoUpdateCallback;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;

public class PojoDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, TableDataProvider<?>> _tables;
    private final String _schemaName;

    public PojoDataContext() {
        this(new ArrayList());
    }

    public PojoDataContext(List<TableDataProvider<?>> tables) {
        this("Schema", tables);
    }

    public PojoDataContext(String schemaName, TableDataProvider ... tableProviders) {
        this(schemaName, Arrays.asList(tableProviders));
    }

    public PojoDataContext(String schemaName, List<TableDataProvider<?>> tables) {
        if (schemaName == null) {
            throw new IllegalArgumentException("Schema name cannot be null");
        }
        this._schemaName = schemaName;
        this._tables = new TreeMap();
        for (TableDataProvider<?> pojoTable : tables) {
            this.addTableDataProvider(pojoTable);
        }
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        TableDataProvider<?> pojoTable = this._tables.get(table.getName());
        if (pojoTable == null) {
            throw new IllegalArgumentException("No such POJO table: " + table.getName());
        }
        SelectItem[] selectItems = MetaModelHelper.createSelectItems((Column[])columns);
        MaxRowsDataSet dataSet = new PojoDataSet(pojoTable, selectItems);
        if (maxRows > 0) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        for (TableDataProvider<?> pojoTable : this._tables.values()) {
            SimpleTableDef tableDef = pojoTable.getTableDef();
            MutableTable table = tableDef.toTable();
            table.setSchema((Schema)schema);
            schema.addTable(table);
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript update) {
        PojoUpdateCallback updateCallback = new PojoUpdateCallback(this);
        PojoDataContext pojoDataContext = this;
        synchronized (pojoDataContext) {
            update.run((UpdateCallback)updateCallback);
        }
    }

    protected void addTableDataProvider(TableDataProvider<?> tableDataProvider) {
        this._tables.put(tableDataProvider.getName(), tableDataProvider);
    }

    public void insert(String tableName, Map<String, Object> recordData) {
        TableDataProvider<?> table = this._tables.get(tableName);
        if (table == null) {
            throw new IllegalArgumentException("No table data provider for table: " + tableName);
        }
        table.insert(recordData);
    }
}

