/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.salesforce;

import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.FirstRowDataSet;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.OrderByItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.salesforce.SalesforceDataSet;
import org.apache.metamodel.salesforce.SalesforceSchema;
import org.apache.metamodel.salesforce.SalesforceUpdateCallback;
import org.apache.metamodel.salesforce.SalesforceUtils;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    public static final TimeZone SOQL_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final String SOQL_DATE_FORMAT_IN = "yyyy-MM-dd";
    public static final String SOQL_DATE_FORMAT_OUT = "yyyy-MM-dd";
    public static final String SOQL_DATE_TIME_FORMAT_IN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String SOQL_DATE_TIME_FORMAT_OUT = "yyyy-MM-dd'T'HH:mm:ssZZZ";
    public static final String SOQL_TIME_FORMAT_IN = "HH:mm:ss.SSS";
    public static final String SOQL_TIME_FORMAT_OUT = "HH:mm:ssZZZ";
    private static final Logger logger = LoggerFactory.getLogger(SalesforceDataContext.class);
    private final PartnerConnection _connection;

    public SalesforceDataContext(String endpoint, String username, String password, String securityToken) {
        super(false);
        try {
            ConnectorConfig config = new ConnectorConfig();
            config.setUsername(username);
            config.setPassword(securityToken == null ? password : password + securityToken);
            if (endpoint != null) {
                config.setAuthEndpoint(endpoint);
                config.setServiceEndpoint(endpoint);
            }
            this._connection = Connector.newConnection((ConnectorConfig)config);
        }
        catch (ConnectionException e) {
            throw SalesforceUtils.wrapException(e, "Failed to log in to Salesforce service");
        }
    }

    public SalesforceDataContext(String username, String password, String securityToken) {
        super(false);
        try {
            this._connection = Connector.newConnection((String)username, (String)(securityToken == null ? password : password + securityToken));
        }
        catch (ConnectionException e) {
            throw SalesforceUtils.wrapException(e, "Failed to log in to Salesforce service");
        }
    }

    public SalesforceDataContext(String username, String password) {
        super(false);
        try {
            this._connection = Connector.newConnection((String)username, (String)password);
        }
        catch (ConnectionException e) {
            throw SalesforceUtils.wrapException(e, "Failed to log in to Salesforce service");
        }
    }

    public SalesforceDataContext(PartnerConnection connection) {
        super(false);
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this._connection = connection;
    }

    public PartnerConnection getConnection() {
        return this._connection;
    }

    protected Schema getMainSchema() throws MetaModelException {
        SalesforceSchema schema = new SalesforceSchema(this.getMainSchemaName(), this._connection);
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return "Salesforce";
    }

    public DataSet executeQuery(Query query) {
        List fromItems = query.getFromClause().getItems();
        if (fromItems.size() != 1) {
            return super.executeQuery(query);
        }
        Table table = ((FromItem)fromItems.get(0)).getTable();
        if (table == null) {
            return super.executeQuery(query);
        }
        if (!query.getGroupByClause().isEmpty()) {
            return super.executeQuery(query);
        }
        if (!query.getHavingClause().isEmpty()) {
            return super.executeQuery(query);
        }
        List selectItems = query.getSelectClause().getItems();
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("SELECT ");
            int i = 0;
            ArrayList<Column> columns = new ArrayList<Column>(selectItems.size());
            for (Object selectItem : selectItems) {
                SalesforceDataContext.validateSoqlSupportedSelectItem((SelectItem)selectItem);
                columns.set(i, selectItem.getColumn());
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(((Column)columns.get(i)).getName());
                ++i;
            }
            sb.append(" FROM ");
            sb.append(table.getName());
            boolean firstWhere = true;
            for (Object filterItem : query.getWhereClause().getItems()) {
                if (firstWhere) {
                    sb.append(" WHERE ");
                    firstWhere = false;
                } else {
                    sb.append(" AND ");
                }
                SalesforceDataContext.rewriteFilterItem(sb, (FilterItem)filterItem);
            }
            i = 0;
            List items = query.getOrderByClause().getItems();
            for (OrderByItem orderByItem : items) {
                if (i == 0) {
                    sb.append(" ORDER BY ");
                } else {
                    sb.append(", ");
                }
                SelectItem selectItem = orderByItem.getSelectItem();
                SalesforceDataContext.validateSoqlSupportedSelectItem(selectItem);
                Column column = selectItem.getColumn();
                sb.append(column.getName());
                sb.append(' ');
                sb.append(orderByItem.getDirection());
                ++i;
            }
            Integer firstRow = query.getFirstRow();
            Integer maxRows = query.getMaxRows();
            if (maxRows != null && maxRows > 0) {
                if (firstRow != null) {
                    sb.append(" LIMIT " + (maxRows + firstRow - 1));
                } else {
                    sb.append(" LIMIT " + maxRows);
                }
            }
            QueryResult result = this.executeSoqlQuery(sb.toString());
            SalesforceDataSet dataSet = new SalesforceDataSet(columns, result, this._connection);
            if (firstRow != null) {
                dataSet = new FirstRowDataSet((DataSet)dataSet, firstRow.intValue());
            }
            return dataSet;
        }
        catch (UnsupportedOperationException e) {
            logger.debug("Failed to rewrite query to SOQL, falling back to regular query post-processing", (Throwable)e);
            return super.executeQuery(query);
        }
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        String query;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT COUNT() FROM ");
            sb.append(table.getName());
            boolean firstWhere = true;
            for (FilterItem filterItem : whereItems) {
                if (firstWhere) {
                    sb.append(" WHERE ");
                    firstWhere = false;
                } else {
                    sb.append(" AND ");
                }
                SalesforceDataContext.rewriteFilterItem(sb, filterItem);
            }
            query = sb.toString();
        }
        catch (UnsupportedOperationException e) {
            logger.debug("Failed to rewrite count query, falling back to client side counting", (Throwable)e);
            return null;
        }
        QueryResult queryResult = this.executeSoqlQuery(query);
        assert (queryResult.isDone());
        return queryResult.getSize();
    }

    protected static void rewriteFilterItem(StringBuilder sb, FilterItem filterItem) throws UnsupportedOperationException {
        if (filterItem.isCompoundFilter()) {
            FilterItem[] childrend = filterItem.getChildItems();
            boolean firstChild = true;
            sb.append('(');
            for (FilterItem child : childrend) {
                if (firstChild) {
                    firstChild = false;
                } else {
                    sb.append(' ');
                    sb.append(filterItem.getLogicalOperator().toString());
                    sb.append(' ');
                }
                SalesforceDataContext.rewriteFilterItem(sb, child);
            }
            sb.append(')');
            return;
        }
        SelectItem selectItem = filterItem.getSelectItem();
        SalesforceDataContext.validateSoqlSupportedSelectItem(selectItem);
        Column column = selectItem.getColumn();
        sb.append(column.getName());
        sb.append(' ');
        OperatorType operator = filterItem.getOperator();
        if (OperatorType.IN.equals(operator)) {
            throw new UnsupportedOperationException("IN operator not supported: " + filterItem);
        }
        sb.append(operator.toSql());
        sb.append(' ');
        Object operand = filterItem.getOperand();
        if (operand == null) {
            sb.append("null");
        } else if (operand instanceof String) {
            sb.append('\'');
            String str = operand.toString();
            str = str.replaceAll("'", "\\\\'");
            str = str.replaceAll("\"", "\\\\\"");
            str = str.replaceAll("\r", "\\\\r");
            str = str.replaceAll("\n", "\\\\n");
            str = str.replaceAll("\t", "\\\\t");
            sb.append(str);
            sb.append('\'');
        } else if (operand instanceof Number) {
            sb.append(operand);
        } else if (operand instanceof Date) {
            SimpleDateFormat dateFormat;
            ColumnType expectedColumnType = selectItem.getExpectedColumnType();
            if (expectedColumnType == ColumnType.DATE) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            } else if (expectedColumnType == ColumnType.TIME) {
                dateFormat = new SimpleDateFormat(SOQL_TIME_FORMAT_OUT, Locale.ENGLISH);
                dateFormat.setTimeZone(SOQL_TIMEZONE);
            } else {
                dateFormat = new SimpleDateFormat(SOQL_DATE_TIME_FORMAT_OUT, Locale.ENGLISH);
                dateFormat.setTimeZone(SOQL_TIMEZONE);
            }
            String str = dateFormat.format((Date)operand);
            logger.debug("Date '{}' formatted as: {}", operand, (Object)str);
            sb.append(str);
        } else if (operand instanceof Column) {
            sb.append(((Column)operand).getName());
        } else if (operand instanceof SelectItem) {
            SelectItem operandSelectItem = (SelectItem)operand;
            SalesforceDataContext.validateSoqlSupportedSelectItem(operandSelectItem);
            sb.append(operandSelectItem.getColumn().getName());
        } else {
            throw new UnsupportedOperationException("Unsupported operand: " + operand);
        }
    }

    private static void validateSoqlSupportedSelectItem(SelectItem selectItem) throws UnsupportedOperationException {
        if (selectItem.hasFunction()) {
            throw new UnsupportedOperationException("Function select items not supported: " + selectItem);
        }
        if (selectItem.getSubQuerySelectItem() != null) {
            throw new UnsupportedOperationException("Subquery select items not supported: " + selectItem);
        }
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(columns.get(i).getName());
        }
        sb.append(" FROM ");
        sb.append(table.getName());
        if (maxRows > 0) {
            sb.append(" LIMIT " + maxRows);
        }
        QueryResult queryResult = this.executeSoqlQuery(sb.toString());
        return new SalesforceDataSet(columns, queryResult, this._connection);
    }

    private QueryResult executeSoqlQuery(String query) {
        logger.info("Executing SOQL query: {}", (Object)query);
        try {
            QueryResult queryResult = this._connection.query(query);
            return queryResult;
        }
        catch (ConnectionException e) {
            throw SalesforceUtils.wrapException(e, "Failed to invoke query service");
        }
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        SalesforceUpdateCallback callback = new SalesforceUpdateCallback(this, this._connection);
        update.run((UpdateCallback)callback);
        callback.close();
        return callback.getUpdateSummary();
    }
}

