/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.sugarcrm;

import com.sugarcrm.ws.soap.FieldList;
import com.sugarcrm.ws.soap.NewModuleFields;
import com.sugarcrm.ws.soap.SelectFields;
import com.sugarcrm.ws.soap.SugarsoapPortType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.schema.AbstractTable;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.sugarcrm.SugarCrmXmlHelper;
import org.apache.metamodel.util.LazyRef;
import org.apache.metamodel.util.Ref;
import org.w3c.dom.Node;

final class SugarCrmTable
extends AbstractTable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ColumnType> TYPE_MAPPING = new HashMap<String, ColumnType>();
    private final String _name;
    private final Schema _schema;
    private final Ref<List<Column>> _columnsRef;

    public SugarCrmTable(String name, Schema schema, final SugarsoapPortType service, final Ref<String> sessionId) {
        this._name = name;
        this._schema = schema;
        this._columnsRef = new LazyRef<List<Column>>(){

            protected List<Column> fetch() {
                ArrayList<Column> result = new ArrayList<Column>();
                String session = (String)sessionId.get();
                NewModuleFields fields = service.getModuleFields(session, SugarCrmTable.this._name, new SelectFields());
                FieldList moduleFields = fields.getModuleFields();
                List<Object> list = moduleFields.getAny();
                for (Object object : list) {
                    if (!(object instanceof Node)) continue;
                    Node node = (Node)object;
                    String name = SugarCrmXmlHelper.getChildElementText(node, "name");
                    String nativeType = SugarCrmXmlHelper.getChildElementText(node, "type");
                    String remarks = SugarCrmXmlHelper.getChildElementText(node, "label");
                    ColumnType columnType = SugarCrmTable.this.convertToColumnType(nativeType);
                    MutableColumn column = new MutableColumn(name, columnType).setNativeType(nativeType).setRemarks(remarks).setTable((Table)SugarCrmTable.this);
                    result.add((Column)column);
                }
                return result;
            }
        };
    }

    public String getName() {
        return this._name;
    }

    public Column[] getColumns() {
        List columns = (List)this._columnsRef.get();
        return columns.toArray(new Column[columns.size()]);
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableType getType() {
        return TableType.TABLE;
    }

    public Relationship[] getRelationships() {
        return new Relationship[0];
    }

    public String getRemarks() {
        return null;
    }

    public String getQuote() {
        return null;
    }

    private ColumnType convertToColumnType(String sugarType) {
        ColumnType columnType = TYPE_MAPPING.get(sugarType);
        if (columnType == null) {
            columnType = ColumnType.OTHER;
        }
        return columnType;
    }

    static {
        TYPE_MAPPING.put("name", ColumnType.VARCHAR);
        TYPE_MAPPING.put("assigned_user_name", ColumnType.VARCHAR);
        TYPE_MAPPING.put("text", ColumnType.VARCHAR);
        TYPE_MAPPING.put("enum", ColumnType.VARCHAR);
        TYPE_MAPPING.put("varchar", ColumnType.VARCHAR);
        TYPE_MAPPING.put("phone", ColumnType.VARCHAR);
        TYPE_MAPPING.put("fullname", ColumnType.VARCHAR);
        TYPE_MAPPING.put("url", ColumnType.VARCHAR);
        TYPE_MAPPING.put("relate", ColumnType.VARCHAR);
        TYPE_MAPPING.put("email", ColumnType.VARCHAR);
        TYPE_MAPPING.put("parent", ColumnType.VARCHAR);
        TYPE_MAPPING.put("parent_type", ColumnType.VARCHAR);
        TYPE_MAPPING.put("currency", ColumnType.VARCHAR);
        TYPE_MAPPING.put("none", ColumnType.VARCHAR);
        TYPE_MAPPING.put("user_name", ColumnType.VARCHAR);
        TYPE_MAPPING.put("file", ColumnType.VARCHAR);
        TYPE_MAPPING.put("id", ColumnType.VARCHAR);
        TYPE_MAPPING.put("int", ColumnType.INTEGER);
        TYPE_MAPPING.put("bool", ColumnType.BOOLEAN);
        TYPE_MAPPING.put("date", ColumnType.DATE);
        TYPE_MAPPING.put("datetime", ColumnType.DATE);
        TYPE_MAPPING.put("datetimecombo", ColumnType.DATE);
    }
}

