/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.apache.mina.integration.beans.AbstractPropertyEditor;
import org.apache.mina.integration.beans.CollectionEditor;
import org.apache.mina.integration.beans.PropertyEditorFactory;

public class ArrayEditor
extends AbstractPropertyEditor {
    private final Class<?> componentType;

    public ArrayEditor(Class<?> componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("componentType");
        }
        this.componentType = componentType;
        this.getComponentEditor();
        this.setTrimText(false);
    }

    private PropertyEditor getComponentEditor() {
        PropertyEditor e = PropertyEditorFactory.getInstance(this.componentType);
        if (e == null) {
            throw new IllegalArgumentException("No " + PropertyEditor.class.getSimpleName() + " found for " + this.componentType.getSimpleName() + '.');
        }
        return e;
    }

    @Override
    protected String toText(Object value) {
        Class<?> componentType = value.getClass().getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("not an array: " + value);
        }
        PropertyEditor e = PropertyEditorFactory.getInstance(componentType);
        if (e == null) {
            throw new IllegalArgumentException("No " + PropertyEditor.class.getSimpleName() + " found for " + componentType.getSimpleName() + '.');
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < Array.getLength(value); ++i) {
            e.setValue(Array.get(value, i));
            String s = e.getAsText();
            buf.append(s);
            buf.append(", ");
        }
        if (buf.length() >= 2) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    @Override
    protected Object toValue(String text) throws IllegalArgumentException {
        PropertyEditor e = this.getComponentEditor();
        ArrayList<Object> values = new ArrayList<Object>();
        Matcher m = CollectionEditor.ELEMENT.matcher(text);
        boolean matchedDelimiter = true;
        while (m.find()) {
            if (m.group(1) != null) {
                matchedDelimiter = true;
                continue;
            }
            if (!matchedDelimiter) {
                throw new IllegalArgumentException("No delimiter between elements: " + text);
            }
            e.setAsText(m.group());
            values.add(e.getValue());
            matchedDelimiter = false;
            if (m.group(2) == null && m.group(3) == null) continue;
            m.region(m.end() + 1, m.regionEnd());
        }
        Object answer = Array.newInstance(this.componentType, values.size());
        for (int i = 0; i < Array.getLength(answer); ++i) {
            Array.set(answer, i, values.get(i));
        }
        return answer;
    }
}

