/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class AdaptNbVersion {
    public static final String TYPE_SPECIFICATION = "spec";
    public static final String TYPE_IMPLEMENTATION = "impl";
    private static final String SNAPSHOT = "SNAPSHOT";

    public static String adaptVersion(String version, Object type, Date date) {
        StringTokenizer tok = new StringTokenizer(version, ".");
        if (SNAPSHOT.equals(version) && TYPE_IMPLEMENTATION.equals(type)) {
            return "0.0.0." + AdaptNbVersion.generateSnapshotValue(date);
        }
        StringBuilder toReturn = new StringBuilder();
        while (tok.hasMoreTokens()) {
            int snapshotIndex;
            Object token = tok.nextToken();
            if (TYPE_IMPLEMENTATION.equals(type) && (snapshotIndex = ((String)token).indexOf(SNAPSHOT)) > 0) {
                Object repl = ((String)token).substring(0, snapshotIndex) + AdaptNbVersion.generateSnapshotValue(date);
                if (((String)token).length() > snapshotIndex + SNAPSHOT.length()) {
                    repl = ((String)token).substring(snapshotIndex + SNAPSHOT.length());
                }
                token = repl;
            }
            if (TYPE_SPECIFICATION.equals(type)) {
                if (((String)token).indexOf(45) > 0) {
                    token = ((String)token).substring(0, ((String)token).indexOf(45));
                } else if (((String)token).indexOf(95) > 0) {
                    token = ((String)token).substring(0, ((String)token).indexOf(95));
                }
                try {
                    Integer intValue = Integer.valueOf((String)token);
                    token = intValue.toString();
                }
                catch (NumberFormatException exc) {
                    token = "";
                }
            }
            if (((String)token).length() <= 0) continue;
            if (toReturn.length() != 0) {
                toReturn.append(".");
            }
            toReturn.append((String)token);
        }
        if (toReturn.length() == 0) {
            toReturn.append("0.0.0");
        }
        String result = toReturn.toString();
        if (TYPE_SPECIFICATION.equals(type)) {
            result = AdaptNbVersion.computeSpecificationVersion(result);
        }
        return result;
    }

    private static String generateSnapshotValue(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    private static String computeSpecificationVersion(String v) {
        int pos = -1;
        for (int i = 0; i < 3; ++i) {
            if ((pos = v.indexOf(46, pos + 1)) != -1) continue;
            return v;
        }
        return v.substring(0, pos);
    }
}

