/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="branding", requiresProject=true, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class BrandingMojo
extends AbstractNbmMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/nbm")
    protected File nbmBuildDir;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File outputDirectory;
    @Parameter(required=true, defaultValue="${basedir}/src/main/nbm-branding")
    private File brandingSources;
    @Parameter(property="netbeans.branding.token")
    private String brandingToken;
    @Parameter(required=true, defaultValue="extra")
    protected String cluster;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (!"nbm".equals(this.project.getPackaging())) {
            this.getLog().error((CharSequence)"The nbm:branding goal shall be used within a NetBeans module project only (packaging 'nbm')");
        }
        if (!this.brandingSources.isDirectory()) {
            this.getLog().info((CharSequence)"No branding to process.");
            return;
        }
        if (this.brandingToken == null) {
            throw new MojoExecutionException("brandingToken must be defined for mojo:branding");
        }
        try {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{"**/*.*"});
            scanner.addDefaultExcludes();
            scanner.setBasedir(this.brandingSources);
            scanner.scan();
            String clusterPathPart = "clusters" + File.separator + this.cluster;
            File outputDir = new File(this.outputDirectory, "branding_and_locales");
            outputDir.mkdirs();
            File clusterDir = new File(this.nbmBuildDir, clusterPathPart);
            clusterDir.mkdirs();
            for (String brandingFilePath : scanner.getIncludedFiles()) {
                File brandingFile = new File(this.brandingSources, brandingFilePath);
                String[] locale = BrandingMojo.getLocale(brandingFile.getName());
                String token = locale[1] == null ? this.brandingToken : this.brandingToken + "_" + locale[1];
                File root = new File(outputDir, token);
                root.mkdirs();
                String destinationName = locale[0] + "_" + token + locale[2];
                File brandingDestination = new File(root, brandingFilePath.replace(brandingFile.getName(), destinationName));
                if (!brandingDestination.getParentFile().exists()) {
                    brandingDestination.getParentFile().mkdirs();
                }
                FileUtils.copyFile((File)brandingFile, (File)brandingDestination);
            }
            for (File rootDir : outputDir.listFiles()) {
                if (!rootDir.isDirectory()) continue;
                String effectiveBranding = rootDir.getName();
                scanner.setIncludes(new String[]{"**/*.jar"});
                scanner.setBasedir(rootDir);
                scanner.scan();
                for (String jarDirectoryPath : scanner.getIncludedDirectories()) {
                    File jarDirectory = new File(rootDir, jarDirectoryPath);
                    File destinationLocation = new File(clusterDir, jarDirectoryPath).getParentFile();
                    destinationLocation.mkdirs();
                    File destinationJar = new File(destinationLocation + File.separator + "locale" + File.separator + BrandingMojo.destinationFileName(jarDirectory.getName(), effectiveBranding));
                    JarArchiver archiver = new JarArchiver();
                    archiver.setDestFile(destinationJar);
                    archiver.addDirectory(jarDirectory);
                    archiver.createArchive();
                }
            }
        }
        catch (IOException | IllegalStateException | ArchiverException ex) {
            throw new MojoExecutionException("Error creating branding", (Exception)ex);
        }
    }

    static String destinationFileName(String brandingFilePath, String branding) {
        int lastSeparator = brandingFilePath.lastIndexOf(File.separator);
        String infix = "_" + branding;
        int lastDot = brandingFilePath.lastIndexOf(".");
        if (lastDot == -1 || lastDot < lastSeparator) {
            return brandingFilePath + infix;
        }
        return brandingFilePath.substring(0, lastDot) + infix + brandingFilePath.substring(lastDot);
    }

    static String[] getLocale(String name) {
        String loc1;
        int underscore;
        String suffix = "";
        int dot = name.indexOf(".");
        if (dot > -1) {
            suffix = name.substring(dot);
            name = name.substring(0, dot);
        }
        String locale = null;
        for (int count = 1; count <= 3 && (underscore = name.lastIndexOf(95)) > -1 && (loc1 = name.substring(underscore + 1)).length() == 2; ++count) {
            locale = loc1 + (String)(locale == null ? "" : "_" + locale);
            name = name.substring(0, underscore);
        }
        return new String[]{name, locale, suffix};
    }
}

