/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.util.StringUtils;

@Deprecated(forRemoval=true, since="14.3")
@Mojo(name="build-installers", requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class BuildInstallersMojo
extends AbstractNbmMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File outputDirectory;
    @Parameter(property="netbeans.branding.token", required=true)
    protected String brandingToken;
    @Parameter(property="netbeans.branding.token")
    protected String installDirName;
    @Parameter(defaultValue="${project.build.finalName}")
    private String installersFilePrefix;
    @Parameter(defaultValue="true")
    private boolean installerOsWindows;
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean installerOsSolaris;
    @Parameter(defaultValue="true")
    private boolean installerOsLinux;
    @Parameter(defaultValue="true")
    private boolean installerOsMacosx;
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean installerPack200Enable;
    @Parameter(defaultValue="${basedir}/license.txt")
    private File installerLicenseFile;
    @Parameter
    private File templateFile;
    @Parameter
    private Map<String, String> userSettings;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    private final MavenProjectHelper projectHelper;
    @Parameter(readonly=true, required=true, property="basedir")
    private File basedir;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    @Inject
    public BuildInstallersMojo(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Project antProject = this.antProject();
        if (!"nbm-application".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only makes sense on project with 'nbm-application' packaging.");
        }
        if (!(this.installerOsLinux || this.installerOsMacosx || this.installerOsSolaris || this.installerOsWindows)) {
            this.getLog().warn((CharSequence)"None of the Operating System Installers selected, skipping 'build-installers' goal.");
            return;
        }
        String zipName = this.finalName + ".zip";
        File zipFile = new File(this.outputDirectory, zipName);
        this.getLog().info((CharSequence)String.format("Running Build Installers action for (existing=%2$s) zip file %1$s", zipFile, zipFile.exists()));
        FileUrlUtils fu = new FileUrlUtils();
        File harnessDir = new File(this.outputDirectory, "installer");
        fu.copyResourcesRecursively(((Object)((Object)this)).getClass().getClassLoader().getResource("harness"), harnessDir);
        if (this.templateFile != null) {
            File template = new File(harnessDir, "nbi/stub/template.xml");
            fu.copyFile(this.templateFile, template);
        }
        File appIconIcnsFile = new File(harnessDir, "etc" + File.separatorChar + "applicationIcon.icns");
        this.getLog().info((CharSequence)("Application icon:" + appIconIcnsFile.getAbsolutePath()));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("suite.location", this.basedir.getAbsolutePath().replace("\\", "/"));
        props.put("suite.props.app.name", this.brandingToken);
        props.put("suite.dist.zip", zipFile.getAbsolutePath().replace("\\", "/"));
        props.put("suite.dist.directory", this.outputDirectory.getAbsolutePath().replace("\\", "/"));
        props.put("installer.build.dir", new File(this.outputDirectory, "installerbuild").getAbsolutePath().replace("\\", "/"));
        props.put("installers.file.prefix", this.installersFilePrefix);
        String appName = this.project.getParent().getArtifactId().replace(".", "").replace("-", "").replace("_", "").replaceAll("[0-9]+", "");
        props.put("suite.nbi.product.uid", appName.toLowerCase(Locale.ENGLISH));
        props.put("suite.props.app.title", (this.project.getName() + " " + this.project.getVersion()).replaceAll("-SNAPSHOT", ""));
        Object appVersion = this.project.getVersion().replaceAll("-SNAPSHOT", "");
        props.put("suite.nbi.product.version.short", appVersion);
        while (((String)appVersion).split("\\.").length < 5) {
            appVersion = (String)appVersion + ".0";
        }
        props.put("suite.nbi.product.version", appVersion);
        props.put("nbi.stub.location", new File(harnessDir, "nbi/stub").getAbsolutePath().replace("\\", "/"));
        props.put("nbi.stub.common.location", new File(harnessDir, "nbi/.common").getAbsolutePath().replace("\\", "/"));
        props.put("nbi.ant.tasks.jar", new File(harnessDir, "modules/ext/nbi-ant-tasks.jar").getAbsolutePath().replace("\\", "/"));
        props.put("nbi.registries.management.jar", new File(harnessDir, "modules/ext/nbi-registries-management.jar").getAbsolutePath().replace("\\", "/"));
        props.put("nbi.engine.jar", new File(harnessDir, "modules/ext/nbi-engine.jar").getAbsolutePath().replace("\\", "/"));
        if (this.installerLicenseFile != null) {
            this.getLog().info((CharSequence)String.format("License file is at %1s, exist = %2$s", this.installerLicenseFile, this.installerLicenseFile.exists()));
            props.put("nbi.license.file", this.installerLicenseFile.getAbsolutePath());
        }
        ArrayList<String> platforms = new ArrayList<String>();
        if (this.installerOsLinux) {
            platforms.add("linux");
            File linuxFile = new File(this.outputDirectory, this.installersFilePrefix + "-linux.sh");
            this.projectHelper.attachArtifact(this.project, "sh", "linux", linuxFile);
        }
        if (this.installerOsSolaris) {
            platforms.add("solaris");
            File solarisFile = new File(this.outputDirectory, this.installersFilePrefix + "-solaris.sh");
            this.projectHelper.attachArtifact(this.project, "sh", "solaris", solarisFile);
        }
        if (this.installerOsWindows) {
            platforms.add("windows");
            File windowsFile = new File(this.outputDirectory, this.installersFilePrefix + "-windows.exe");
            this.projectHelper.attachArtifact(this.project, "exe", "windows", windowsFile);
        }
        if (this.installerOsMacosx) {
            platforms.add("macosx");
            File macosxFile = new File(this.outputDirectory, this.installersFilePrefix + "-macosx.tgz");
            this.projectHelper.attachArtifact(this.project, "tgz", "macosx", macosxFile);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < platforms.size(); ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append((String)platforms.get(i));
        }
        if (sb.length() == 0) {
            this.getLog().warn((CharSequence)"Nothing to build.");
        }
        props.put("generate.installer.for.platforms", sb.toString());
        File javaHome = new File(System.getProperty("java.home"));
        if (new File(javaHome, "lib/rt.jar").exists() && javaHome.getName().equals("jre")) {
            javaHome = javaHome.getParentFile();
        }
        props.put("generator-jdk-location-forward-slashes", javaHome.getAbsolutePath().replace("\\", "/"));
        props.put("pack200.enabled", "" + this.installerPack200Enable);
        props.put("nbi.dock.icon.file", appIconIcnsFile.getAbsolutePath());
        try {
            antProject.setUserProperty("ant.file", new File(harnessDir, "nbi/stub/template.xml").getAbsolutePath().replace("\\", "/"));
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            antProject.addReference("ant.projectHelper", (Object)helper);
            helper.parse(antProject, (Object)new File(harnessDir, "nbi/stub/template.xml"));
            for (Map.Entry entry : props.entrySet()) {
                antProject.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.userSettings != null) {
                for (Map.Entry<Object, Object> entry : this.userSettings.entrySet()) {
                    antProject.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            antProject.executeTarget("build");
        }
        catch (BuildException ex) {
            throw new MojoExecutionException("Installers creation failed: " + ex, (Exception)((Object)ex));
        }
    }

    private static class FileUrlUtils {
        private FileUrlUtils() {
        }

        boolean copyFile(File toCopy, File destFile) throws MojoExecutionException {
            try {
                return this.copyStream((InputStream)new FileInputStream(toCopy), new FileOutputStream(destFile));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Installers creation failed: " + e, (Exception)e);
            }
        }

        boolean copyFilesRecursively(File toCopy, File destDir) throws MojoExecutionException {
            assert (destDir.isDirectory());
            if (!toCopy.isDirectory()) {
                return this.copyFile(toCopy, new File(destDir, toCopy.getName()));
            }
            File newDestDir = new File(destDir, toCopy.getName());
            if (!newDestDir.exists() && !newDestDir.mkdir()) {
                return false;
            }
            for (File child : toCopy.listFiles()) {
                if (this.copyFilesRecursively(child, newDestDir)) continue;
                return false;
            }
            return true;
        }

        boolean copyJarResourcesRecursively(File destDir, JarURLConnection jarConnection) throws IOException, MojoExecutionException {
            JarFile jarFile = jarConnection.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
                String filename = StringUtils.removePrefix((String)entry.getName(), (String)jarConnection.getEntryName());
                File f = new File(destDir, filename);
                if (!entry.isDirectory()) {
                    InputStream entryInputStream = jarFile.getInputStream(entry);
                    if (!this.copyStream(entryInputStream, f)) {
                        return false;
                    }
                    entryInputStream.close();
                    continue;
                }
                if (this.ensureDirectoryExists(f)) continue;
                throw new IOException("Could not create directory: " + f.getAbsolutePath());
            }
            return true;
        }

        boolean copyResourcesRecursively(URL originUrl, File destination) throws MojoExecutionException {
            try {
                URLConnection urlConnection = originUrl.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    return this.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
                }
                return this.copyFilesRecursively(new File(originUrl.getPath()), destination);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Installers creation failed: " + e, (Exception)e);
            }
        }

        boolean copyStream(InputStream is, File f) throws MojoExecutionException {
            try {
                return this.copyStream(is, new FileOutputStream(f));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Installers creation failed: " + e, (Exception)e);
            }
        }

        boolean copyStream(InputStream is, OutputStream os) throws MojoExecutionException {
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    os.write(buf, 0, len);
                }
                is.close();
                os.close();
                return true;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Installers creation failed: " + e, (Exception)e);
            }
        }

        boolean ensureDirectoryExists(File f) {
            return f.exists() || f.mkdir();
        }
    }
}

