/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.apache.netbeans.nbm.CreateClusterAppMojo;
import org.apache.netbeans.nbm.utils.ExamineManifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="cluster", aggregator=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CreateClusterMojo
extends AbstractNbmMojo {
    @Parameter(defaultValue="${project.build.directory}/nbm", property="maven.nbm.buildDir")
    protected File nbmBuildDir;
    @Parameter(required=true, defaultValue="extra")
    protected String cluster;
    @Parameter(defaultValue="${project.build.directory}/netbeans_clusters", required=true)
    protected File clusterBuildDir;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List reactorProjects;
        Project antProject = this.registerNbmAntTasks();
        if (!this.clusterBuildDir.exists()) {
            this.clusterBuildDir.mkdirs();
        }
        if ((reactorProjects = this.mavenSession.getProjects()) != null && !reactorProjects.isEmpty()) {
            for (MavenProject proj : reactorProjects) {
                File nbmDir = new File(this.nbmBuildDir, "clusters");
                if (nbmDir.exists()) {
                    Copy copyTask = (Copy)antProject.createTask("copy");
                    copyTask.setTodir(this.clusterBuildDir);
                    copyTask.setOverwrite(true);
                    FileSet set = new FileSet();
                    set.setDir(nbmDir);
                    set.createInclude().setName("**");
                    copyTask.addFileset(set);
                    try {
                        copyTask.execute();
                        continue;
                    }
                    catch (BuildException ex) {
                        this.getLog().error((CharSequence)"Cannot merge modules into cluster");
                        throw new MojoExecutionException("Cannot merge modules into cluster", (Exception)((Object)ex));
                    }
                }
                if ("nbm".equals(proj.getPackaging())) {
                    String error = "The NetBeans binary directory structure for " + proj.getId() + " is not created yet.\n Please execute 'mvn install nbm:cluster' to build all relevant projects in the reactor.";
                    throw new MojoFailureException(error);
                }
                if (!"bundle".equals(proj.getPackaging())) continue;
                Artifact art = proj.getArtifact();
                ExamineManifest mnf = new ExamineManifest(this.getLog());
                File jar = new File(proj.getBuild().getDirectory(), proj.getBuild().getFinalName() + ".jar");
                if (!jar.exists()) {
                    this.getLog().error((CharSequence)("Skipping " + proj.getId() + ". Cannot find the main artifact in output directory."));
                    continue;
                }
                mnf.setJarFile(jar);
                mnf.checkFile();
                File clusterDir = new File(this.clusterBuildDir, this.cluster);
                this.getLog().debug((CharSequence)("Copying " + art.getId() + " to cluster " + this.cluster));
                File modules = new File(clusterDir, "modules");
                modules.mkdirs();
                File config = new File(clusterDir, "config");
                File confModules = new File(config, "Modules");
                confModules.mkdirs();
                File updateTracting = new File(clusterDir, "update_tracking");
                updateTracting.mkdirs();
                String cnb = mnf.getModule();
                String cnbDashed = cnb.replace(".", "-");
                File moduleArt = new File(modules, cnbDashed + ".jar");
                String specVer = mnf.getSpecVersion();
                try {
                    FileUtils.copyFile((File)jar, (File)moduleArt);
                    File moduleConf = new File(confModules, cnbDashed + ".xml");
                    FileUtils.copyStreamToFile(() -> new StringInputStream(CreateClusterAppMojo.createBundleConfigFile(cnb, mnf.isBundleAutoload()), "UTF-8"), (File)moduleConf);
                    FileUtils.copyStreamToFile(() -> new StringInputStream(CreateClusterAppMojo.createBundleUpdateTracking(cnb, moduleArt, moduleConf, specVer), "UTF-8"), (File)new File(updateTracting, cnbDashed + ".xml"));
                }
                catch (IOException exc) {
                    this.getLog().error((Throwable)exc);
                }
            }
            File[] files = this.clusterBuildDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                File stamp = new File(files[i], ".lastModified");
                if (!stamp.exists()) {
                    try {
                        stamp.createNewFile();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                stamp.setLastModified(CreateClusterMojo.getOutputTimestampOrNow(this.mavenSession.getCurrentProject()).getTime());
            }
        } else {
            throw new MojoExecutionException("This goal only makes sense on reactor projects.");
        }
        this.getLog().info((CharSequence)("Created NetBeans module cluster(s) at " + this.clusterBuildDir));
    }
}

