/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.archiver.gzip.GZipArchiver;
import org.netbeans.nbbuild.MakeUpdateDesc;

@Mojo(name="autoupdate", defaultPhase=LifecyclePhase.PACKAGE, aggregator=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CreateUpdateSiteMojo
extends AbstractNbmMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @Parameter(defaultValue="updates.xml", property="maven.nbm.updatesitexml")
    protected String fileName;
    @Parameter(defaultValue=".", property="maven.nbm.customDistBase")
    private String distBase;
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    @Parameter(required=true, readonly=true, defaultValue="${reactorProjects}")
    private List reactorProjects;
    @Parameter
    private List<String> updateSiteIncludes;
    private final ArtifactFactory artifactFactory;
    private final MavenProjectHelper projectHelper;
    private final ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    private final Map<String, ArtifactRepositoryLayout> layouts;
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");

    @Inject
    public CreateUpdateSiteMojo(ArtifactFactory artifactFactory, MavenProjectHelper projectHelper, ArtifactResolver artifactResolver, Map<String, ArtifactRepositoryLayout> layouts) {
        this.artifactFactory = artifactFactory;
        this.projectHelper = projectHelper;
        this.artifactResolver = artifactResolver;
        this.layouts = layouts;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Project antProject = this.registerNbmAntTasks();
        File nbmBuildDirFile = new File(this.outputDirectory, "netbeans_site");
        if (!nbmBuildDirFile.exists()) {
            nbmBuildDirFile.mkdirs();
        }
        boolean isRepository = false;
        if ("auto".equals(this.distBase)) {
            this.distBase = null;
        }
        ArtifactRepository distRepository = CreateUpdateSiteMojo.getDeploymentRepository(this.distBase, this.layouts);
        String oldDistBase = null;
        if (distRepository != null) {
            isRepository = true;
        } else if (this.distBase != null && !this.distBase.contains("::")) {
            oldDistBase = this.distBase;
        }
        if ("nbm-application".equals(this.project.getPackaging())) {
            Set artifacts = this.project.getArtifacts();
            for (Artifact art : artifacts) {
                if (!this.matchesIncludes(art)) continue;
                AbstractNbmMojo.ArtifactResult res = this.turnJarToNbmFile(art, this.artifactFactory, this.artifactResolver, this.project, this.session.getLocalRepository());
                if (res.hasConvertedArtifact()) {
                    art = res.getConvertedArtifact();
                }
                if (art.getType().equals("nbm-file")) {
                    Copy copyTask = (Copy)antProject.createTask("copy");
                    copyTask.setOverwrite(true);
                    copyTask.setFile(art.getFile());
                    if (!isRepository) {
                        copyTask.setFlatten(true);
                        copyTask.setTodir(nbmBuildDirFile);
                    } else {
                        String path = distRepository.pathOf(art);
                        File f = new File(nbmBuildDirFile, path.replace('/', File.separatorChar));
                        copyTask.setTofile(f);
                    }
                    try {
                        copyTask.execute();
                    }
                    catch (BuildException ex) {
                        throw new MojoExecutionException("Cannot merge nbm files into autoupdate site", (Exception)((Object)ex));
                    }
                }
                if (!res.isOSGiBundle()) continue;
            }
            this.getLog().info((CharSequence)("Created NetBeans module cluster(s) at " + nbmBuildDirFile.getAbsoluteFile()));
        } else if (this.reactorProjects != null && this.reactorProjects.size() > 0) {
            for (MavenProject proj : this.reactorProjects) {
                File projOutputDirectory = new File(proj.getBuild().getDirectory());
                if (projOutputDirectory == null || !projOutputDirectory.exists()) continue;
                Copy copyTask = (Copy)antProject.createTask("copy");
                if (!isRepository) {
                    FileSet fs = new FileSet();
                    fs.setDir(projOutputDirectory);
                    fs.createInclude().setName("*.nbm");
                    copyTask.addFileset(fs);
                    copyTask.setOverwrite(true);
                    copyTask.setFlatten(true);
                    copyTask.setTodir(nbmBuildDirFile);
                } else {
                    boolean has = false;
                    File[] fls = projOutputDirectory.listFiles();
                    if (fls != null) {
                        for (File fl : fls) {
                            if (!fl.getName().endsWith(".nbm")) continue;
                            copyTask.setFile(fl);
                            has = true;
                            break;
                        }
                    }
                    if (!has) continue;
                    Artifact art = this.artifactFactory.createArtifact(proj.getGroupId(), proj.getArtifactId(), proj.getVersion(), null, "nbm-file");
                    String path = distRepository.pathOf(art);
                    File f = new File(nbmBuildDirFile, path.replace('/', File.separatorChar));
                    copyTask.setTofile(f);
                }
                try {
                    copyTask.execute();
                }
                catch (BuildException ex) {
                    throw new MojoExecutionException("Cannot merge nbm files into autoupdate site", (Exception)((Object)ex));
                }
            }
        } else {
            throw new MojoExecutionException("This goal only makes sense on reactor projects or project with 'nbm-application' packaging.");
        }
        MakeUpdateDesc descTask = (MakeUpdateDesc)antProject.createTask("updatedist");
        File xmlFile = new File(nbmBuildDirFile, this.fileName);
        descTask.setDesc(xmlFile);
        if (oldDistBase != null) {
            descTask.setDistBase(oldDistBase);
        }
        if (distRepository != null) {
            descTask.setDistBase(distRepository.getUrl());
        }
        FileSet fs = new FileSet();
        fs.setDir(nbmBuildDirFile);
        fs.createInclude().setName("**/*.nbm");
        descTask.addFileset(fs);
        try {
            descTask.execute();
        }
        catch (BuildException ex) {
            throw new MojoExecutionException("Cannot create autoupdate site xml file", (Exception)((Object)ex));
        }
        this.getLog().info((CharSequence)("Generated autoupdate site content at " + nbmBuildDirFile.getAbsolutePath()));
        try {
            GZipArchiver gz = new GZipArchiver();
            gz.addFile(xmlFile, this.fileName);
            File gzipped = new File(nbmBuildDirFile, this.fileName + ".gz");
            gz.setDestFile(gzipped);
            gz.createArchive();
            if ("nbm-application".equals(this.project.getPackaging())) {
                this.projectHelper.attachArtifact(this.project, "xml.gz", "updatesite", gzipped);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot create gzipped version of the update site xml file.", ex);
        }
    }

    static ArtifactRepository getDeploymentRepository(String distBase, Map<String, ArtifactRepositoryLayout> layouts) throws MojoExecutionException, MojoFailureException {
        DefaultArtifactRepository repo = null;
        if (distBase != null) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(distBase);
            if (!matcher.matches()) {
                if (!distBase.contains("::")) {
                    return null;
                }
                throw new MojoFailureException((Object)distBase, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::layout::url\".");
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            ArtifactRepositoryLayout repoLayout = layouts.get(layout);
            if (repoLayout == null) {
                throw new MojoExecutionException("Cannot find repository layout: " + layout);
            }
            repo = new DefaultArtifactRepository(id, url, repoLayout);
        }
        return repo;
    }

    private boolean matchesIncludes(Artifact art) {
        if (this.updateSiteIncludes != null) {
            String s = art.getGroupId() + ":" + art.getArtifactId();
            for (String p : this.updateSiteIncludes) {
                Pattern patt = Pattern.compile(p = p.replace(".", "\\.").replace("*", ".*"));
                if (!patt.matcher(s).matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

