/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.Arrays;

public enum RequiredPermission {
    READ_FILESYSTEM("read-filesystem", "read filesystem"),
    WRITE_FILESYSTEM("write-filesystem", "write filesystem"),
    READ_DISTRIBUTED_FILESYSTEM("read-distributed-filesystem", "read distributed filesystem"),
    WRITE_DISTRIBUTED_FILESYSTEM("write-distributed-filesystem", "write distributed filesystem"),
    EXECUTE_CODE("execute-code", "execute code"),
    ACCESS_KEYTAB("access-keytab", "access keytab"),
    EXPORT_NIFI_DETAILS("export-nifi-details", "export nifi details");

    private String permissionIdentifier;
    private String permissionLabel;

    private RequiredPermission(String permissionIdentifier, String permissionLabel) {
        this.permissionIdentifier = permissionIdentifier;
        this.permissionLabel = permissionLabel;
    }

    public String getPermissionIdentifier() {
        return this.permissionIdentifier;
    }

    public String getPermissionLabel() {
        return this.permissionLabel;
    }

    public static RequiredPermission valueOfPermissionIdentifier(String permissionIdentifier) {
        return Arrays.stream(RequiredPermission.values()).filter(candidate -> candidate.getPermissionIdentifier().equals(permissionIdentifier)).findFirst().orElse(null);
    }
}

