/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConfigurableComponent;
import org.apache.nifi.flow.VersionedExtensionComponent;
import org.apache.nifi.flow.VersionedPropertyDescriptor;

public class VersionedProcessor
extends VersionedComponent
implements VersionedConfigurableComponent,
VersionedExtensionComponent {
    private Bundle bundle;
    private Map<String, String> style;
    private String type;
    private Map<String, String> properties;
    private Map<String, VersionedPropertyDescriptor> propertyDescriptors;
    private String annotationData;
    private String schedulingPeriod;
    private String schedulingStrategy;
    private String executionNode;
    private String penaltyDuration;
    private String yieldDuration;
    private String bulletinLevel;
    private Long runDurationMillis;
    private Integer concurrentlySchedulableTaskCount;
    private Set<String> autoTerminatedRelationships;
    private ScheduledState scheduledState;

    @ApiModelProperty(value="The frequency with which to schedule the processor. The format of the value will depend on th value of schedulingStrategy.")
    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public void setSchedulingPeriod(String setSchedulingPeriod) {
        this.schedulingPeriod = setSchedulingPeriod;
    }

    @ApiModelProperty(value="Indcates whether the prcessor should be scheduled to run in event or timer driven mode.")
    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public void setSchedulingStrategy(String schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    @Override
    @ApiModelProperty(value="The type of Processor")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(value="Indicates the node where the process will execute.")
    public String getExecutionNode() {
        return this.executionNode;
    }

    public void setExecutionNode(String executionNode) {
        this.executionNode = executionNode;
    }

    @ApiModelProperty(value="The amout of time that is used when the process penalizes a flowfile.")
    public String getPenaltyDuration() {
        return this.penaltyDuration;
    }

    public void setPenaltyDuration(String penaltyDuration) {
        this.penaltyDuration = penaltyDuration;
    }

    @ApiModelProperty(value="The amount of time that must elapse before this processor is scheduled again after yielding.")
    public String getYieldDuration() {
        return this.yieldDuration;
    }

    public void setYieldDuration(String yieldDuration) {
        this.yieldDuration = yieldDuration;
    }

    @ApiModelProperty(value="The level at which the processor will report bulletins.")
    public String getBulletinLevel() {
        return this.bulletinLevel;
    }

    public void setBulletinLevel(String bulletinLevel) {
        this.bulletinLevel = bulletinLevel;
    }

    @ApiModelProperty(value="The number of tasks that should be concurrently schedule for the processor. If the processor doesn't allow parallol processing then any positive input will be ignored.")
    public Integer getConcurrentlySchedulableTaskCount() {
        return this.concurrentlySchedulableTaskCount;
    }

    public void setConcurrentlySchedulableTaskCount(Integer concurrentlySchedulableTaskCount) {
        this.concurrentlySchedulableTaskCount = concurrentlySchedulableTaskCount;
    }

    @Override
    @ApiModelProperty(value="The properties for the processor. Properties whose value is not set will only contain the property name.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    @ApiModelProperty(value="The property descriptors for the processor.")
    public Map<String, VersionedPropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public void setPropertyDescriptors(Map<String, VersionedPropertyDescriptor> propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
    }

    @ApiModelProperty(value="The annotation data for the processor used to relay configuration between a custom UI and the procesosr.")
    public String getAnnotationData() {
        return this.annotationData;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    @ApiModelProperty(value="The names of all relationships that cause a flow file to be terminated if the relationship is not connected elsewhere. This property differs from the 'isAutoTerminate' property of the RelationshipDTO in that the RelationshipDTO is meant to depict the current configuration, whereas this property can be set in a DTO when updating a Processor in order to change which Relationships should be auto-terminated.")
    public Set<String> getAutoTerminatedRelationships() {
        return this.autoTerminatedRelationships;
    }

    public void setAutoTerminatedRelationships(Set<String> autoTerminatedRelationships) {
        this.autoTerminatedRelationships = autoTerminatedRelationships;
    }

    @ApiModelProperty(value="The run duration for the processor in milliseconds.")
    public Long getRunDurationMillis() {
        return this.runDurationMillis;
    }

    public void setRunDurationMillis(Long runDurationMillis) {
        this.runDurationMillis = runDurationMillis;
    }

    @Override
    @ApiModelProperty(value="Information about the bundle from which the component came")
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    @ApiModelProperty(value="Stylistic data for rendering in a UI")
    public Map<String, String> getStyle() {
        return this.style;
    }

    public void setStyle(Map<String, String> style) {
        this.style = style;
    }

    @ApiModelProperty(value="The scheduled state of the component")
    public ScheduledState getScheduledState() {
        return this.scheduledState;
    }

    public void setScheduledState(ScheduledState scheduledState) {
        this.scheduledState = scheduledState;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.PROCESSOR;
    }
}

