/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.nifi.logging.LogLevel;

public class LogMessage {
    private final long time;
    private final String message;
    private final LogLevel logLevel;
    private final Throwable throwable;
    private final String flowFileUuid;
    private final Object[] objects;
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String TO_STRING_FORMAT = "%1$s %2$s - %3$s";

    private LogMessage(long time, LogLevel logLevel, String message, Throwable throwable, String flowFileUuid, Object[] objects) {
        this.logLevel = logLevel;
        this.throwable = throwable;
        this.message = message;
        this.time = time;
        this.flowFileUuid = flowFileUuid;
        this.objects = objects;
    }

    public long getTime() {
        return this.time;
    }

    public String getMessage() {
        return this.message;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getFlowFileUuid() {
        return this.flowFileUuid;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.US);
        String formattedTime = dateFormat.format(new Date(this.time));
        Object formattedMsg = String.format(TO_STRING_FORMAT, formattedTime, this.logLevel.toString(), this.message);
        if (this.throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.throwable.printStackTrace(pw);
            formattedMsg = (String)formattedMsg + System.lineSeparator() + String.valueOf(sw);
        }
        return formattedMsg;
    }

    public static class Builder {
        private final long time;
        private final LogLevel logLevel;
        private String message;
        private Throwable throwable;
        private String flowFileUuid;
        private Object[] objects;

        public Builder(long time, LogLevel logLevel) {
            this.time = time;
            this.logLevel = logLevel;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public Builder flowFileUuid(String flowFileUuid) {
            this.flowFileUuid = flowFileUuid;
            return this;
        }

        public Builder objects(Object[] objects) {
            this.objects = objects;
            return this;
        }

        public LogMessage createLogMessage() {
            return new LogMessage(this.time, this.logLevel, this.message, this.throwable, this.flowFileUuid, this.objects);
        }
    }
}

