/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.util.NumberUtil;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;

@XmlType(name="processGroup")
public class ProcessGroupDTO
extends ComponentDTO {
    private String name;
    private String comments;
    private VersionControlInformationDTO versionControlInformation;
    private ParameterContextReferenceEntity parameterContext;
    private String flowfileConcurrency;
    private String flowfileOutboundPolicy;
    private String defaultFlowFileExpiration;
    private Long defaultBackPressureObjectThreshold;
    private String defaultBackPressureDataSizeThreshold;
    private String logFileSuffix;
    private String executionEngine;
    private Integer maxConcurrentTasks;
    private String statelessFlowTimeout;
    private Integer runningCount;
    private Integer stoppedCount;
    private Integer invalidCount;
    private Integer disabledCount;
    private Integer activeRemotePortCount;
    private Integer inactiveRemotePortCount;
    private Integer upToDateCount;
    private Integer locallyModifiedCount;
    private Integer staleCount;
    private Integer locallyModifiedAndStaleCount;
    private Integer syncFailureCount;
    private Integer localInputPortCount;
    private Integer localOutputPortCount;
    private Integer publicInputPortCount;
    private Integer publicOutputPortCount;
    private String statelessGroupScheduledState;
    private FlowSnippetDTO contents;

    @ApiModelProperty(value="The name of the process group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The comments for the process group.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(value="The contents of this process group.")
    public FlowSnippetDTO getContents() {
        return this.contents;
    }

    public void setContents(FlowSnippetDTO contents) {
        this.contents = contents;
    }

    @ApiModelProperty(value="The number of input ports in the process group.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Integer getInputPortCount() {
        return NumberUtil.sumNullableIntegers(this.localInputPortCount, this.publicInputPortCount);
    }

    public void setInputPortCount(Integer inputPortCount) {
    }

    @ApiModelProperty(value="The number of local input ports in the process group.")
    public Integer getLocalInputPortCount() {
        return this.localInputPortCount;
    }

    public void setLocalInputPortCount(Integer localInputPortCount) {
        this.localInputPortCount = localInputPortCount;
    }

    @ApiModelProperty(value="The number of public input ports in the process group.")
    public Integer getPublicInputPortCount() {
        return this.publicInputPortCount;
    }

    public void setPublicInputPortCount(Integer publicInputPortCount) {
        this.publicInputPortCount = publicInputPortCount;
    }

    @ApiModelProperty(value="The number of invalid components in the process group.")
    public Integer getInvalidCount() {
        return this.invalidCount;
    }

    public void setInvalidCount(Integer invalidCount) {
        this.invalidCount = invalidCount;
    }

    @ApiModelProperty(value="The number of output ports in the process group.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Integer getOutputPortCount() {
        return NumberUtil.sumNullableIntegers(this.localOutputPortCount, this.publicOutputPortCount);
    }

    public void setOutputPortCount(Integer outputPortCount) {
    }

    @ApiModelProperty(value="The number of local output ports in the process group.")
    public Integer getLocalOutputPortCount() {
        return this.localOutputPortCount;
    }

    public void setLocalOutputPortCount(Integer localOutputPortCount) {
        this.localOutputPortCount = localOutputPortCount;
    }

    @ApiModelProperty(value="The number of public output ports in the process group.")
    public Integer getPublicOutputPortCount() {
        return this.publicOutputPortCount;
    }

    public void setPublicOutputPortCount(Integer publicOutputPortCount) {
        this.publicOutputPortCount = publicOutputPortCount;
    }

    @ApiModelProperty(value="The number of running components in this process group.")
    public Integer getRunningCount() {
        return this.runningCount;
    }

    public void setRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
    }

    @ApiModelProperty(value="The number of stopped components in the process group.")
    public Integer getStoppedCount() {
        return this.stoppedCount;
    }

    public void setStoppedCount(Integer stoppedCount) {
        this.stoppedCount = stoppedCount;
    }

    @ApiModelProperty(value="The number of disabled components in the process group.")
    public Integer getDisabledCount() {
        return this.disabledCount;
    }

    public void setDisabledCount(Integer disabledCount) {
        this.disabledCount = disabledCount;
    }

    @ApiModelProperty(value="The number of active remote ports in the process group.")
    public Integer getActiveRemotePortCount() {
        return this.activeRemotePortCount;
    }

    public void setActiveRemotePortCount(Integer activeRemotePortCount) {
        this.activeRemotePortCount = activeRemotePortCount;
    }

    @ApiModelProperty(value="The number of inactive remote ports in the process group.")
    public Integer getInactiveRemotePortCount() {
        return this.inactiveRemotePortCount;
    }

    public void setInactiveRemotePortCount(Integer inactiveRemotePortCount) {
        this.inactiveRemotePortCount = inactiveRemotePortCount;
    }

    @ApiModelProperty(value="The number of up to date versioned process groups in the process group.")
    public Integer getUpToDateCount() {
        return this.upToDateCount;
    }

    public void setUpToDateCount(Integer upToDateCount) {
        this.upToDateCount = upToDateCount;
    }

    @ApiModelProperty(value="The number of locally modified versioned process groups in the process group.")
    public Integer getLocallyModifiedCount() {
        return this.locallyModifiedCount;
    }

    public void setLocallyModifiedCount(Integer locallyModifiedCount) {
        this.locallyModifiedCount = locallyModifiedCount;
    }

    @ApiModelProperty(value="The number of stale versioned process groups in the process group.")
    public Integer getStaleCount() {
        return this.staleCount;
    }

    public void setStaleCount(Integer staleCount) {
        this.staleCount = staleCount;
    }

    @ApiModelProperty(value="The number of locally modified and stale versioned process groups in the process group.")
    public Integer getLocallyModifiedAndStaleCount() {
        return this.locallyModifiedAndStaleCount;
    }

    public void setLocallyModifiedAndStaleCount(Integer locallyModifiedAndStaleCount) {
        this.locallyModifiedAndStaleCount = locallyModifiedAndStaleCount;
    }

    @ApiModelProperty(value="The number of versioned process groups in the process group that are unable to sync to a registry.")
    public Integer getSyncFailureCount() {
        return this.syncFailureCount;
    }

    public void setSyncFailureCount(Integer syncFailureCount) {
        this.syncFailureCount = syncFailureCount;
    }

    @ApiModelProperty(value="The Version Control information that indicates which Flow Registry, and where in the Flow Registry, this Process Group is tracking to; or null if this Process Group is not under version control")
    public VersionControlInformationDTO getVersionControlInformation() {
        return this.versionControlInformation;
    }

    public void setVersionControlInformation(VersionControlInformationDTO versionControlInformation) {
        this.versionControlInformation = versionControlInformation;
    }

    @ApiModelProperty(value="The Parameter Context that this Process Group is bound to.")
    public ParameterContextReferenceEntity getParameterContext() {
        return this.parameterContext;
    }

    public void setParameterContext(ParameterContextReferenceEntity parameterContext) {
        this.parameterContext = parameterContext;
    }

    @ApiModelProperty(value="The FlowFile Concurrency for this Process Group.", allowableValues="UNBOUNDED, SINGLE_FLOWFILE_PER_NODE, SINGLE_BATCH_PER_NODE")
    public String getFlowfileConcurrency() {
        return this.flowfileConcurrency;
    }

    public void setFlowfileConcurrency(String flowfileConcurrency) {
        this.flowfileConcurrency = flowfileConcurrency;
    }

    @ApiModelProperty(value="The Outbound Policy that is used for determining how FlowFiles should be transferred out of the Process Group.", allowableValues="STREAM_WHEN_AVAILABLE, BATCH_OUTPUT")
    public String getFlowfileOutboundPolicy() {
        return this.flowfileOutboundPolicy;
    }

    public void setFlowfileOutboundPolicy(String flowfileOutboundPolicy) {
        this.flowfileOutboundPolicy = flowfileOutboundPolicy;
    }

    @ApiModelProperty(value="The default FlowFile Expiration for this Process Group.")
    public String getDefaultFlowFileExpiration() {
        return this.defaultFlowFileExpiration;
    }

    public void setDefaultFlowFileExpiration(String defaultFlowFileExpiration) {
        this.defaultFlowFileExpiration = defaultFlowFileExpiration;
    }

    @ApiModelProperty(value="Default value used in this Process Group for the maximum number of objects that can be queued before back pressure is applied.")
    public Long getDefaultBackPressureObjectThreshold() {
        return this.defaultBackPressureObjectThreshold;
    }

    public void setDefaultBackPressureObjectThreshold(Long defaultBackPressureObjectThreshold) {
        this.defaultBackPressureObjectThreshold = defaultBackPressureObjectThreshold;
    }

    @ApiModelProperty(value="Default value used in this Process Group for the maximum data size of objects that can be queued before back pressure is applied.")
    public String getDefaultBackPressureDataSizeThreshold() {
        return this.defaultBackPressureDataSizeThreshold;
    }

    public void setDefaultBackPressureDataSizeThreshold(String defaultBackPressureDataSizeThreshold) {
        this.defaultBackPressureDataSizeThreshold = defaultBackPressureDataSizeThreshold;
    }

    @ApiModelProperty(value="The log file suffix for this Process Group for dedicated logging.")
    public String getLogFileSuffix() {
        return this.logFileSuffix;
    }

    public void setLogFileSuffix(String logFileSuffix) {
        this.logFileSuffix = logFileSuffix;
    }

    @ApiModelProperty(value="The Execution Engine that should be used to run the flow represented by this Process Group.", allowableValues="STATELESS, STANDARD, INHERITED")
    public String getExecutionEngine() {
        return this.executionEngine;
    }

    public void setExecutionEngine(String executionEngine) {
        this.executionEngine = executionEngine;
    }

    @ApiModelProperty(value="If the Process Group is configured to run in using the Stateless Engine, represents the current state. Otherwise, will be STOPPED.", allowableValues="STOPPED, RUNNING")
    public String getStatelessGroupScheduledState() {
        return this.statelessGroupScheduledState;
    }

    public void setStatelessGroupScheduledState(String state) {
        this.statelessGroupScheduledState = state;
    }

    @ApiModelProperty(value="The maximum number of concurrent tasks to use when running the flow using the Stateless Engine")
    public Integer getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public void setMaxConcurrentTasks(Integer maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    @ApiModelProperty(value="The maximum amount of time that the flow can be run using the Stateless Engine before the flow times out")
    public String getStatelessFlowTimeout() {
        return this.statelessFlowTimeout;
    }

    public void setStatelessFlowTimeout(String timeout) {
        this.statelessFlowTimeout = timeout;
    }
}

