/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;

@XmlType(name="processorConfig")
public class ProcessorConfigDTO {
    private Map<String, String> properties;
    private Map<String, PropertyDescriptorDTO> descriptors;
    private Set<String> sensitiveDynamicPropertyNames;
    private String schedulingPeriod;
    private String schedulingStrategy;
    private String executionNode;
    private String penaltyDuration;
    private String yieldDuration;
    private String bulletinLevel;
    private Long runDurationMillis;
    private Integer concurrentlySchedulableTaskCount;
    private Set<String> autoTerminatedRelationships;
    private String comments;
    private String customUiUrl;
    private Boolean lossTolerant;
    private String annotationData;
    private Map<String, String> defaultConcurrentTasks;
    private Map<String, String> defaultSchedulingPeriod;
    private Integer retryCount;
    private Set<String> retriedRelationships;
    private String backoffMechanism;
    private String maxBackoffPeriod;

    @ApiModelProperty(value="The frequency with which to schedule the processor. The format of the value will depend on th value of schedulingStrategy.")
    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public void setSchedulingPeriod(String setSchedulingPeriod) {
        this.schedulingPeriod = setSchedulingPeriod;
    }

    @ApiModelProperty(value="Indicates how the processor should be scheduled to run.")
    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public void setSchedulingStrategy(String schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    @ApiModelProperty(value="Indicates the node where the process will execute.")
    public String getExecutionNode() {
        return this.executionNode;
    }

    public void setExecutionNode(String executionNode) {
        this.executionNode = executionNode;
    }

    @ApiModelProperty(value="The amount of time that is used when the process penalizes a flowfile.")
    public String getPenaltyDuration() {
        return this.penaltyDuration;
    }

    public void setPenaltyDuration(String penaltyDuration) {
        this.penaltyDuration = penaltyDuration;
    }

    @ApiModelProperty(value="The amount of time that must elapse before this processor is scheduled again after yielding.")
    public String getYieldDuration() {
        return this.yieldDuration;
    }

    public void setYieldDuration(String yieldDuration) {
        this.yieldDuration = yieldDuration;
    }

    @ApiModelProperty(value="The level at which the processor will report bulletins.")
    public String getBulletinLevel() {
        return this.bulletinLevel;
    }

    public void setBulletinLevel(String bulletinLevel) {
        this.bulletinLevel = bulletinLevel;
    }

    @ApiModelProperty(value="The number of tasks that should be concurrently schedule for the processor. If the processor doesn't allow parallol processing then any positive input will be ignored.")
    public Integer getConcurrentlySchedulableTaskCount() {
        return this.concurrentlySchedulableTaskCount;
    }

    public void setConcurrentlySchedulableTaskCount(Integer concurrentlySchedulableTaskCount) {
        this.concurrentlySchedulableTaskCount = concurrentlySchedulableTaskCount;
    }

    @ApiModelProperty(value="Whether the processor is loss tolerant.")
    public Boolean isLossTolerant() {
        return this.lossTolerant;
    }

    public void setLossTolerant(Boolean lossTolerant) {
        this.lossTolerant = lossTolerant;
    }

    @ApiModelProperty(value="The comments for the processor.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(value="The properties for the processor. Properties whose value is not set will only contain the property name.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @ApiModelProperty(value="Descriptors for the processor's properties.")
    public Map<String, PropertyDescriptorDTO> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Map<String, PropertyDescriptorDTO> descriptors) {
        this.descriptors = descriptors;
    }

    @ApiModelProperty(value="Set of sensitive dynamic property names")
    public Set<String> getSensitiveDynamicPropertyNames() {
        return this.sensitiveDynamicPropertyNames;
    }

    public void setSensitiveDynamicPropertyNames(Set<String> sensitiveDynamicPropertyNames) {
        this.sensitiveDynamicPropertyNames = sensitiveDynamicPropertyNames;
    }

    @ApiModelProperty(value="The annotation data for the processor used to relay configuration between a custom UI and the procesosr.")
    public String getAnnotationData() {
        return this.annotationData;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    @ApiModelProperty(value="The URL for the processor's custom configuration UI if applicable.")
    public String getCustomUiUrl() {
        return this.customUiUrl;
    }

    public void setCustomUiUrl(String customUiUrl) {
        this.customUiUrl = customUiUrl;
    }

    @ApiModelProperty(value="The names of all relationships that cause a flow file to be terminated if the relationship is not connected elsewhere. This property differs from the 'isAutoTerminate' property of the RelationshipDTO in that the RelationshipDTO is meant to depict the current configuration, whereas this property can be set in a DTO when updating a Processor in order to change which Relationships should be auto-terminated.")
    public Set<String> getAutoTerminatedRelationships() {
        return this.autoTerminatedRelationships;
    }

    public void setAutoTerminatedRelationships(Set<String> autoTerminatedRelationships) {
        this.autoTerminatedRelationships = autoTerminatedRelationships;
    }

    @ApiModelProperty(value="Maps default values for concurrent tasks for each applicable scheduling strategy.")
    public Map<String, String> getDefaultConcurrentTasks() {
        return this.defaultConcurrentTasks;
    }

    public void setDefaultConcurrentTasks(Map<String, String> defaultConcurrentTasks) {
        this.defaultConcurrentTasks = defaultConcurrentTasks;
    }

    @ApiModelProperty(value="The run duration for the processor in milliseconds.")
    public Long getRunDurationMillis() {
        return this.runDurationMillis;
    }

    public void setRunDurationMillis(Long runDurationMillis) {
        this.runDurationMillis = runDurationMillis;
    }

    @ApiModelProperty(value="Maps default values for scheduling period for each applicable scheduling strategy.")
    public Map<String, String> getDefaultSchedulingPeriod() {
        return this.defaultSchedulingPeriod;
    }

    public void setDefaultSchedulingPeriod(Map<String, String> defaultSchedulingPeriod) {
        this.defaultSchedulingPeriod = defaultSchedulingPeriod;
    }

    @ApiModelProperty(value="Overall number of retries.")
    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    @ApiModelProperty(value="All the relationships should be retried.")
    public Set<String> getRetriedRelationships() {
        return this.retriedRelationships;
    }

    public void setRetriedRelationships(Set<String> retriedRelationships) {
        this.retriedRelationships = retriedRelationships;
    }

    @ApiModelProperty(accessMode=ApiModelProperty.AccessMode.READ_ONLY, value="Determines whether the FlowFile should be penalized or the processor should be yielded between retries.", allowableValues="PENALIZE_FLOWFILE, YIELD_PROCESSOR")
    public String getBackoffMechanism() {
        return this.backoffMechanism;
    }

    public void setBackoffMechanism(String backoffMechanism) {
        this.backoffMechanism = backoffMechanism;
    }

    @ApiModelProperty(value="Maximum amount of time to be waited during a retry period.")
    public String getMaxBackoffPeriod() {
        return this.maxBackoffPeriod;
    }

    public void setMaxBackoffPeriod(String maxBackoffPeriod) {
        this.maxBackoffPeriod = maxBackoffPeriod;
    }
}

