/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp.utils;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.util.FormatUtils;

public enum DefaultDataSourceValues {
    MAX_WAIT_TIME("500 millis"){

        @Override
        public Long getLongValue() {
            return (long)FormatUtils.getPreciseTimeDuration((String)MAX_WAIT_TIME.value, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }
    ,
    MAX_TOTAL_CONNECTIONS("8"),
    MIN_IDLE("0"),
    MAX_IDLE("8"),
    MAX_CONN_LIFETIME("-1"),
    EVICTION_RUN_PERIOD("-1"),
    MIN_EVICTABLE_IDLE_TIME("30 mins"){

        @Override
        public Long getLongValue() {
            return (long)FormatUtils.getPreciseTimeDuration((String)MAX_WAIT_TIME.value, (TimeUnit)TimeUnit.MINUTES);
        }
    }
    ,
    SOFT_MIN_EVICTABLE_IDLE_TIME("-1");

    private final String value;

    private DefaultDataSourceValues(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Long getLongValue() {
        return Long.parseLong(this.value);
    }
}

