/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.dbcp.AbstractDBCPConnectionPool;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.utils.DBCPProperties;
import org.apache.nifi.dbcp.utils.DataSourceConfiguration;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@SupportsSensitiveDynamicProperties
@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service. Connections can be asked from pool and returned after usage.")
@DynamicProperties(value={@DynamicProperty(name="JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.ENVIRONMENT, description="JDBC driver property name and value applied to JDBC connections."), @DynamicProperty(name="SENSITIVE.JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.NONE, description="JDBC driver property name prefixed with 'SENSITIVE.' handled as a sensitive property.")})
@RequiresInstanceClassLoading
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Database Driver Location can reference resources over HTTP")})
public class DBCPConnectionPool
extends AbstractDBCPConnectionPool
implements DBCPService,
VerifiableControllerService {
    protected static final String SENSITIVE_PROPERTY_PREFIX = "SENSITIVE.";
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(DBCPProperties.DATABASE_URL, DBCPProperties.DB_DRIVERNAME, DBCPProperties.DB_DRIVER_LOCATION, DBCPProperties.KERBEROS_USER_SERVICE, DBCPProperties.DB_USER, DBCPProperties.DB_PASSWORD, DBCPProperties.MAX_WAIT_TIME, DBCPProperties.MAX_TOTAL_CONNECTIONS, DBCPProperties.VALIDATION_QUERY, DBCPProperties.MIN_IDLE, DBCPProperties.MAX_IDLE, DBCPProperties.MAX_CONN_LIFETIME, DBCPProperties.EVICTION_RUN_PERIOD, DBCPProperties.MIN_EVICTABLE_IDLE_TIME, DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.removeProperty("kerberos-principal");
        config.removeProperty("kerberos-password");
        config.removeProperty("kerberos-credentials-service");
    }

    BasicDataSource getDataSource() {
        return this.dataSource;
    }

    protected DataSourceConfiguration getDataSourceConfiguration(ConfigurationContext context) {
        String url = context.getProperty(DBCPProperties.DATABASE_URL).evaluateAttributeExpressions().getValue();
        String driverName = context.getProperty(DBCPProperties.DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DBCPProperties.DB_USER).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(DBCPProperties.DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(DBCPProperties.MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(DBCPProperties.VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(DBCPProperties.MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(DBCPProperties.MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        return new DataSourceConfiguration.Builder(url, driverName, user, password).maxTotal(maxTotal.intValue()).validationQuery(validationQuery).maxWaitMillis(maxWaitMillis.longValue()).minIdle(minIdle.intValue()).maxIdle(maxIdle.intValue()).maxConnLifetimeMillis(maxConnLifetimeMillis.longValue()).timeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue()).minEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue()).softMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue()).build();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR);
        if (propertyDescriptorName.startsWith(SENSITIVE_PROPERTY_PREFIX)) {
            builder.sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.NONE);
        } else {
            builder.expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT);
        }
        return builder.build();
    }

    protected Map<String, String> getConnectionProperties(ConfigurationContext context) {
        return this.getDynamicProperties(context).stream().map(descriptor -> {
            PropertyValue propertyValue = context.getProperty(descriptor);
            if (descriptor.isSensitive()) {
                String propertyName = StringUtils.startsWith((CharSequence)descriptor.getName(), (CharSequence)SENSITIVE_PROPERTY_PREFIX) ? StringUtils.substringAfter((String)descriptor.getName(), (String)SENSITIVE_PROPERTY_PREFIX) : descriptor.getName();
                return new AbstractMap.SimpleEntry<String, String>(propertyName, propertyValue.getValue());
            }
            return new AbstractMap.SimpleEntry<String, String>(descriptor.getName(), propertyValue.evaluateAttributeExpressions().getValue());
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    protected Driver getDriver(String driverName, String url) {
        Class<?> clazz;
        try {
            clazz = Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessException("Driver class " + driverName + " is not found", (Throwable)e);
        }
        try {
            return DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            try {
                Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(driver);
                return DriverManager.getDriver(url);
            }
            catch (SQLException e2) {
                throw new ProcessException("No suitable driver for the given Database Connection URL", (Throwable)e2);
            }
            catch (Exception e2) {
                throw new ProcessException("Creating driver instance is failed", (Throwable)e2);
            }
        }
    }
}

