/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.distributed.cache.client.AtomicCacheEntry;
import org.apache.nifi.distributed.cache.client.DistributedCacheClient;
import org.apache.nifi.distributed.cache.client.adapter.AtomicCacheEntryInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.BooleanInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.LongInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.MapInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.MapValuesInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.OutboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.SetInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.ValueInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.VoidInboundAdapter;
import org.apache.nifi.distributed.cache.operations.MapOperation;
import org.apache.nifi.distributed.cache.protocol.ProtocolVersion;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.remote.VersionNegotiatorFactory;
import org.apache.nifi.ssl.SSLContextService;

public class NettyDistributedMapCacheClient
extends DistributedCacheClient {
    private final ComponentLog log;

    public NettyDistributedMapCacheClient(String hostname, int port, int timeoutMillis, SSLContextService sslContextService, VersionNegotiatorFactory factory, String identifier, ComponentLog log) {
        super(hostname, port, timeoutMillis, sslContextService, factory, identifier);
        this.log = Objects.requireNonNull(log, "Component Log required");
    }

    public boolean putIfAbsent(byte[] key, byte[] value) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(MapOperation.PUT_IF_ABSENT.value()).write(key).write(value);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public void put(byte[] key, byte[] value) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(MapOperation.PUT.value()).write(key).write(value);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        if (!inboundAdapter.getResult()) {
            throw new IOException("Server indicated 'put' operation failed");
        }
    }

    public boolean containsKey(byte[] key) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(MapOperation.CONTAINS_KEY.value()).write(key);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public <V> V getAndPutIfAbsent(byte[] key, byte[] value, ValueInboundAdapter<V> valueAdapter) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(MapOperation.GET_AND_PUT_IF_ABSENT.value()).write(key).write(value);
        this.invoke(outboundAdapter, valueAdapter);
        return valueAdapter.getResult();
    }

    public <V> V get(byte[] key, ValueInboundAdapter<V> valueAdapter) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(MapOperation.GET.value()).write(key);
        this.invoke(outboundAdapter, valueAdapter);
        return valueAdapter.getResult();
    }

    public <K, V> Map<K, V> subMap(Collection<byte[]> keys, MapValuesInboundAdapter<K, V> mapAdapter) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().minimumVersion(ProtocolVersion.V3.value()).write(MapOperation.SUBMAP.value()).write(keys);
        this.invoke(outboundAdapter, mapAdapter);
        return mapAdapter.getResult();
    }

    public boolean remove(byte[] key) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(MapOperation.REMOVE.value()).write(key);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public <V> V removeAndGet(byte[] key, ValueInboundAdapter<V> valueAdapter) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().minimumVersion(ProtocolVersion.V3.value()).write(MapOperation.REMOVE_AND_GET.value()).write(key);
        this.invoke(outboundAdapter, valueAdapter);
        return valueAdapter.getResult();
    }

    public long removeByPattern(String regex) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(MapOperation.REMOVE_BY_PATTERN.value()).write(regex);
        LongInboundAdapter inboundAdapter = new LongInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public <K, V> Map<K, V> removeByPatternAndGet(String regex, MapInboundAdapter<K, V> mapAdapter) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().minimumVersion(ProtocolVersion.V3.value()).write(MapOperation.REMOVE_BY_PATTERN_AND_GET.value()).write(regex);
        this.invoke(outboundAdapter, mapAdapter);
        return mapAdapter.getResult();
    }

    public <K, V> AtomicCacheEntry<K, V, Long> fetch(byte[] key, AtomicCacheEntryInboundAdapter<K, V> inboundAdapter) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().minimumVersion(ProtocolVersion.V2.value()).write(MapOperation.FETCH.value()).write(key);
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public boolean replace(byte[] key, byte[] value, long revision) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().minimumVersion(ProtocolVersion.V2.value()).write(MapOperation.REPLACE.value()).write(key).write(revision).write(value);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public <K> Set<K> keySet(SetInboundAdapter<K> setAdapter) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().minimumVersion(ProtocolVersion.V3.value()).write(MapOperation.KEYSET.value());
        this.invoke(outboundAdapter, setAdapter);
        return setAdapter.getResult();
    }

    public void close() throws IOException {
        try {
            this.invoke(new OutboundAdapter().write(MapOperation.CLOSE.value()), new VoidInboundAdapter());
        }
        catch (Exception e) {
            this.log.warn("Sending close command failed: closing channel", (Throwable)e);
        }
        this.closeChannelPool();
    }
}

